/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassHelper;

public abstract class AbstractTransformer
implements UMOTransformer {
    public static final String TRANSFORMER_DEFAULT = "org.mule.transformers.DefaultTransformer";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected Class returnClass = null;
    protected String name = null;
    protected UMOImmutableEndpoint endpoint = null;
    private List sourceTypes = new ArrayList();
    protected UMOTransformer transformer;
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractTransformer() {
        this.name = this.generateTransformerName();
    }

    protected Object checkReturnClass(Object object) throws TransformerException {
        if (this.returnClass != null && !this.returnClass.isInstance(object)) {
            throw new TransformerException("The object transformed is of type: " + object.getClass().getName() + ", but the expected return type is: " + this.returnClass.getName());
        }
        this.logger.debug((Object)("The transformed object is of expected type. Type is: " + object.getClass().getName()));
        return object;
    }

    protected void registerSourceType(Class aClass) {
        if (aClass.equals(class$java$lang$Object == null ? (class$java$lang$Object = AbstractTransformer.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.logger.warn((Object)"java.lang.Object has been added as an exceptable sourcetype to this transformer, there will no source type checking on this transformer");
        }
        this.sourceTypes.add(aClass);
    }

    protected void unregisterSourceType(Class aClass) {
        this.sourceTypes.remove(aClass);
    }

    protected Iterator getSourceTypeClassesIterator() {
        return this.sourceTypes.iterator();
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getClass().getName();
            this.name = this.name.substring(this.name.lastIndexOf(".") + 1);
        }
        this.logger.debug((Object)("Setting transformer name to: " + this.name));
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(Class newClass) {
        this.returnClass = newClass;
    }

    public boolean isSourceTypeSupported(Class aClass) {
        if (this.sourceTypes.isEmpty()) {
            return true;
        }
        Class anotherClass = null;
        Iterator i = this.getSourceTypeClassesIterator();
        while (i.hasNext()) {
            anotherClass = (Class)i.next();
            if (!anotherClass.isAssignableFrom(aClass)) continue;
            return true;
        }
        return false;
    }

    public final Object transform(Object src) throws TransformerException {
        Object result = null;
        if (src instanceof UMOMessage) {
            src = ((UMOMessage)src).getPayload();
        }
        if (!this.isSourceTypeSupported(src.getClass())) {
            throw new TransformerException("This transformer: " + this.getName() + " does not support this source type: " + src.getClass().getName() + ". Endpoint is: " + this.endpoint.getEndpointURI());
        }
        result = this.doTransform(src);
        result = this.checkReturnClass(result);
        if (this.transformer != null) {
            result = this.transformer.transform(result);
        }
        return result;
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(UMOImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        for (UMOTransformer trans = this.transformer; trans != null && endpoint != null; trans = trans.getTransformer()) {
            trans.setEndpoint(endpoint);
        }
    }

    public abstract Object doTransform(Object var1) throws TransformerException;

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(UMOTransformer transformer) {
        this.transformer = transformer;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Object c = BeanUtils.cloneBean((Object)this);
            return (UMOTransformer)c;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException("Failed to clone transformer: " + e.getMessage());
        }
    }

    public Class getFinalReturnClass() {
        AbstractTransformer returnTrans = this;
        for (UMOTransformer tempTrans = this; tempTrans != null; tempTrans = tempTrans.getTransformer()) {
            returnTrans = tempTrans;
        }
        return returnTrans.getReturnClass();
    }

    public void initialise() throws InitialisationException {
    }

    protected String generateTransformerName() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(".");
        if (i > -1) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public void setSourceType(String type) throws ClassNotFoundException {
        Class clazz = ClassHelper.loadClass(type, this.getClass());
        this.registerSourceType(clazz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

