/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers;

import java.util.LinkedList;
import org.mule.transformers.TransformerSession;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class MultiTransformerSession
implements TransformerSession {
    public static final int MAX_STACK_SIZE = 20;
    private boolean inSession = false;
    private LinkedList transformStack = new LinkedList();
    private Object data = null;

    public synchronized void begin() throws TransformerException {
        if (this.inSession) {
            throw new TransformerException("The session is already active");
        }
        this.inSession = true;
        this.data = null;
    }

    public synchronized void commit() throws TransformerException {
        if (!this.inSession) {
            throw new TransformerException("The session is not active");
        }
        this.inSession = false;
        this.transformStack = new LinkedList();
    }

    public synchronized void rollback() throws TransformerException {
        if (!this.inSession) {
            throw new TransformerException("The session is not active");
        }
        if (this.transformStack.size() != 0) {
            this.data = this.transformStack.getFirst();
        }
        this.inSession = false;
        this.transformStack = new LinkedList();
    }

    public Object getData() {
        return this.data;
    }

    public boolean isInSession() {
        return this.inSession;
    }

    public Object transform(UMOTransformer transformer, Object src) throws TransformerException {
        if (!this.isInSession()) {
            this.begin();
        }
        if (this.transformStack.size() == 0) {
            this.pushToStack(src);
        }
        this.data = transformer.transform(src);
        this.pushToStack(this.data);
        return this.data;
    }

    void pushToStack(Object data) {
        if (this.transformStack.size() >= 20) {
            throw new IllegalStateException("The trnasform stack in the MultiTransform session has exceeded it's maximum size.");
        }
        this.transformStack.add(data);
        this.data = data;
    }

    public Object getFromStack(int index) {
        if (index > this.transformStack.size() || index < 0) {
            return null;
        }
        return this.transformStack.get(index);
    }

    public int getStackSize() {
        return this.transformStack.size();
    }
}

