/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers;

import org.mule.transformers.TransformerSession;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class SingleTransformerSession
implements TransformerSession {
    private UMOTransformer transformer = null;
    private boolean inSession = false;
    private Object sourceData = null;
    private Object transData = null;

    public SingleTransformerSession(UMOTransformer transformer) {
        this.transformer = transformer;
    }

    public synchronized void begin() throws TransformerException {
        if (this.inSession) {
            throw new TransformerException("The session is already active");
        }
        this.inSession = true;
        this.sourceData = null;
        this.transData = null;
    }

    public synchronized void commit() throws TransformerException {
        if (!this.inSession) {
            throw new TransformerException("The session is not active");
        }
        this.sourceData = null;
        this.inSession = false;
    }

    public synchronized void rollback() throws TransformerException {
        if (!this.inSession) {
            throw new TransformerException("The session is not active");
        }
        this.transData = this.sourceData;
        this.sourceData = null;
        this.inSession = false;
    }

    public Object getData() {
        return this.transData;
    }

    public boolean isInSession() {
        return this.inSession;
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public Object transform(Object src) throws TransformerException {
        if (!this.isInSession()) {
            this.begin();
        }
        this.sourceData = src;
        this.transData = this.transformer.transform(src);
        return this.transData;
    }

    public Object transform(UMOTransformer trans, Object data) throws TransformerException {
        if (trans != null && !trans.equals(this.transformer) && this.isInSession()) {
            throw new TransformerException("Cannot transform on different transformer while in a session");
        }
        this.transformer = trans;
        return this.transform(data);
    }
}

