/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.encryption;

import org.mule.InitialisationException;
import org.mule.MuleManager;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.security.CryptoFailureException;
import org.mule.umo.transformer.TransformerException;

public abstract class AbstractEncryptionTransformer
extends AbstractTransformer {
    private UMOEncryptionStrategy strategy = null;
    private String strategyName = null;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractEncryptionTransformer() {
        this.registerSourceType(array$B == null ? (array$B = AbstractEncryptionTransformer.class$("[B")) : array$B);
        this.registerSourceType(class$java$lang$String == null ? (class$java$lang$String = AbstractEncryptionTransformer.class$("java.lang.String")) : class$java$lang$String);
        this.setReturnClass(array$B == null ? (array$B = AbstractEncryptionTransformer.class$("[B")) : array$B);
    }

    public Object doTransform(Object src) throws TransformerException {
        byte[] buf = src instanceof String ? src.toString().getBytes() : (byte[])src;
        try {
            byte[] result = this.getTransformedBytes(buf);
            if (this.getReturnClass().equals(class$java$lang$String == null ? (class$java$lang$String = AbstractEncryptionTransformer.class$("java.lang.String")) : class$java$lang$String)) {
                return new String(result);
            }
            return result;
        }
        catch (CryptoFailureException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    protected abstract byte[] getTransformedBytes(byte[] var1) throws CryptoFailureException;

    public void initialise() throws InitialisationException {
        if (this.strategyName != null) {
            if (MuleManager.getInstance().getSecurityManager() == null) {
                if (this.strategy == null) {
                    throw new InitialisationException("Cannot look up encryption strategy as a security manager has not been configured");
                }
            } else {
                this.strategy = MuleManager.getInstance().getSecurityManager().getEncryptionStrategy(this.strategyName);
            }
        }
        if (this.strategy == null) {
            throw new InitialisationException("No encryption strategy has been set on this transformer");
        }
    }

    public UMOEncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(UMOEncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

