/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.ClassHelper;

public abstract class AbstractXStreamTransformer
extends AbstractTransformer {
    private XStream xstream = null;
    private boolean useJaxpDom = false;
    private Map aliases;
    private List converters;

    public final XStream getXStream() throws TransformerException {
        if (this.xstream == null) {
            this.xstream = this.useJaxpDom ? new XStream((HierarchicalStreamDriver)new DomDriver()) : new XStream((HierarchicalStreamDriver)new XppDriver());
        }
        this.addAliases();
        this.addConverters();
        return this.xstream;
    }

    public boolean isUseJaxpDom() {
        return this.useJaxpDom;
    }

    public void setUseJaxpDom(boolean useJaxpDom) {
        this.useJaxpDom = useJaxpDom;
    }

    private void addAliases() throws TransformerException {
        if (this.aliases == null) {
            return;
        }
        Iterator iterator = this.aliases.entrySet().iterator();
        while (iterator.hasNext()) {
            Class clazz;
            Map.Entry entry = iterator.next();
            String classname = entry.getValue().toString();
            try {
                clazz = ClassHelper.loadClass(classname, this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new TransformerException("Failed to load class: " + classname, e);
            }
            this.xstream.alias(entry.getKey().toString(), clazz);
        }
    }

    private void addConverters() throws TransformerException {
        if (this.converters == null) {
            return;
        }
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            String classname = iterator.next().toString();
            try {
                Class clazz = ClassHelper.loadClass(classname, this.getClass());
                this.xstream.registerConverter((Converter)clazz.newInstance());
            }
            catch (Exception e) {
                throw new TransformerException("Failed to load converter: " + classname, e);
            }
        }
    }

    public Map getAliases() {
        return this.aliases;
    }

    public void setAliases(Map aliases) {
        this.aliases = aliases;
    }

    public List getConverters() {
        return this.converters;
    }

    public void setConverters(List converters) {
        this.converters = converters;
    }
}

