/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.mule.InitialisationException;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;

public class XsltTransformer
extends AbstractTransformer {
    private Transformer transformer;
    private String xslFile;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$dom4j$io$DocumentSource;
    static /* synthetic */ Class class$org$dom4j$Document;

    public XsltTransformer() {
        this.registerSourceType(class$java$lang$String == null ? (class$java$lang$String = XsltTransformer.class$("java.lang.String")) : class$java$lang$String);
        this.registerSourceType(class$org$dom4j$io$DocumentSource == null ? (class$org$dom4j$io$DocumentSource = XsltTransformer.class$("org.dom4j.io.DocumentSource")) : class$org$dom4j$io$DocumentSource);
        this.registerSourceType(class$org$dom4j$Document == null ? (class$org$dom4j$Document = XsltTransformer.class$("org.dom4j.Document")) : class$org$dom4j$Document);
    }

    public void initialise() throws InitialisationException {
        try {
            StreamSource source = this.getStreamSource();
            TransformerFactory factory = TransformerFactory.newInstance();
            this.transformer = factory.newTransformer(source);
        }
        catch (Exception e) {
            throw new InitialisationException("Failed to initialize XsltTransformer : " + e, e);
        }
    }

    public Object doTransform(Object src) throws TransformerException {
        try {
            DocumentSource sourceDoc = null;
            DocumentResult resultDoc = new DocumentResult();
            if (src instanceof String) {
                String xml = (String)src;
                Document dom4jDoc = DocumentHelper.parseText((String)xml);
                sourceDoc = new DocumentSource(dom4jDoc);
            } else if (src instanceof DocumentSource) {
                sourceDoc = (DocumentSource)src;
            } else if (src instanceof Document) {
                sourceDoc = new DocumentSource((Document)src);
            }
            this.transformer.transform((Source)sourceDoc, (Result)resultDoc);
            if ((class$org$dom4j$Document == null ? (class$org$dom4j$Document = XsltTransformer.class$("org.dom4j.Document")) : class$org$dom4j$Document).equals(this.returnClass)) {
                return resultDoc.getDocument();
            }
            Document transformedDoc = resultDoc.getDocument();
            return transformedDoc.asXML();
        }
        catch (Exception e) {
            throw new TransformerException("Failed to transform XML : " + e, e);
        }
    }

    public String getXslFile() {
        return this.xslFile;
    }

    public void setXslFile(String xslFile) {
        this.xslFile = xslFile;
    }

    private StreamSource getStreamSource() throws Exception {
        StreamSource source;
        if (this.xslFile == null) {
            throw new TransformerException("Failed to initialize XsltTransformer : xslFile property is not set ");
        }
        File file = new File(this.xslFile);
        if (file.exists()) {
            source = new StreamSource(file);
        } else {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.xslFile);
            if (stream != null) {
                source = new StreamSource(stream);
            } else {
                throw new TransformerException("Failed to initialize XsltTransformer : xslFile (" + this.getXslFile() + ") cannot be found ");
            }
        }
        return source;
    }

    public Object clone() throws CloneNotSupportedException {
        XsltTransformer x = (XsltTransformer)super.clone();
        try {
            if (x.transformer == null) {
                x.initialise();
            }
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return x;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

