/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo.security;

import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UMOSecurityException;

public class UnauthorisedException
extends UMOSecurityException {
    public UnauthorisedException(String message) {
        super(message);
    }

    public UnauthorisedException(String message, Throwable cause) {
        super(message, cause);
    }

    public UnauthorisedException(UMOSecurityContext context, UMOImmutableEndpoint endpoint, UMOEndpointSecurityFilter filter) {
        super(UnauthorisedException.constructMessage(context, endpoint, filter));
    }

    private static String constructMessage(UMOSecurityContext context, UMOImmutableEndpoint endpoint, UMOEndpointSecurityFilter filter) {
        StringBuffer buf = new StringBuffer();
        if (context == null) {
            buf.append("Registered authentication is set to ").append(filter.getClass().getName());
            buf.append(" but there was no security context on the session.");
        } else {
            buf.append("User authentication failed for: " + context.getAuthentication().getPrincipal());
        }
        buf.append("Failed to ");
        buf.append(endpoint.getType().equals("receiver") ? "receive" : "dispatch");
        buf.append(" via endpoint ").append(endpoint.getEndpointURI());
        return buf.toString();
    }
}

