/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.ClassHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MuleDtdResolver
implements EntityResolver {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$config$MuleDtdResolver == null ? (class$org$mule$config$MuleDtdResolver = MuleDtdResolver.class$("org.mule.config.MuleDtdResolver")) : class$org$mule$config$MuleDtdResolver));
    public static final String DEFAULT_MULE_DTD = "mule-configuration.dtd";
    private String dtdName = null;
    private static final String SEARCH_PATH = "";
    private EntityResolver delegate;
    private String xsl;
    private static String currentXsl;
    static /* synthetic */ Class class$org$mule$config$MuleDtdResolver;

    public MuleDtdResolver() {
        this(DEFAULT_MULE_DTD);
    }

    public MuleDtdResolver(String dtdName) {
        this(dtdName, null, null);
    }

    public MuleDtdResolver(String dtdName, String xsl) {
        this(dtdName, xsl, null);
    }

    public MuleDtdResolver(String dtdName, EntityResolver delegate) {
        this(dtdName, null, delegate);
    }

    public MuleDtdResolver(String dtdName, String xsl, EntityResolver delegate) {
        this.dtdName = dtdName;
        this.delegate = delegate;
        this.xsl = xsl;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Created Mule Dtd Resolver: ");
            buffer.append("dtd=").append(dtdName).append(", ");
            buffer.append("xsl=").append(xsl).append(", ");
            buffer.append("delegate resolver=").append(delegate).append(", ");
            logger.debug((Object)buffer.toString());
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        logger.debug((Object)("Trying to resolve XML entity with public ID: " + publicId + " and system ID: " + systemId));
        InputSource source = null;
        currentXsl = null;
        if (this.delegate != null) {
            source = this.delegate.resolveEntity(publicId, systemId);
        }
        if (source == null && systemId != null && systemId.indexOf(this.dtdName) > systemId.lastIndexOf("/")) {
            String dtdFile = systemId.substring(systemId.indexOf(this.dtdName));
            logger.debug((Object)("Looking on classpath for " + dtdFile));
            InputStream is = ClassHelper.getResourceAsStream(SEARCH_PATH + dtdFile, this.getClass());
            if (is != null) {
                source = new InputSource(is);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                logger.debug((Object)("Found on classpath mule DTD: " + systemId));
                currentXsl = this.xsl;
                return source;
            }
            logger.debug((Object)("Could not find dtd resource on classpath: " + dtdFile));
        }
        return source;
    }

    public String getXslForDtd() {
        return currentXsl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

