/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import org.mule.config.pool.CommonsPoolFactory;
import org.mule.umo.model.UMOPoolFactory;

public class PoolingProfile {
    public static final int POOL_INITIALISE_NO_COMPONENTS = 0;
    public static final int POOL_INITIALISE_ONE_COMPONENT = 1;
    public static final int POOL_INITIALISE_ALL_COMPONENTS = 2;
    public static final int DEFAULT_MAX_POOL_ACTIVE = 5;
    public static final int DEFAULT_MAX_POOL_IDLE = 5;
    public static final long DEFAULT_MAX_POOL_WAIT = 4000L;
    public static final int DEFAULT_POOL_EXHAUSTED_ACTION = 2;
    public static final int DEFAULT_POOL_INITIALISATION_POLICY = 1;
    private int maxActive = 5;
    private int maxIdle = 5;
    private long maxWait = 4000L;
    private int exhaustedAction = 2;
    private int initialisationPolicy = 1;
    private UMOPoolFactory poolFactory = new CommonsPoolFactory();

    public PoolingProfile() {
    }

    public PoolingProfile(PoolingProfile pp) {
        this.maxActive = pp.getMaxActive();
        this.maxIdle = pp.getMaxIdle();
        this.maxWait = pp.getMaxWait();
        this.exhaustedAction = pp.getExhaustedAction();
        this.initialisationPolicy = pp.getInitialisationPolicy();
        if (pp.getPoolFactory() != null) {
            this.poolFactory = pp.getPoolFactory();
        }
    }

    public PoolingProfile(int maxActive, int maxIdle, long maxWait, int exhaustedAction, int initialisationPolicy) {
        this.maxActive = maxActive;
        this.maxIdle = maxIdle;
        this.maxWait = maxWait;
        this.exhaustedAction = exhaustedAction;
        this.initialisationPolicy = initialisationPolicy;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public int getExhaustedAction() {
        return this.exhaustedAction;
    }

    public int getInitialisationPolicy() {
        return this.initialisationPolicy;
    }

    public void setInitialisationPolicy(int policy) {
        this.initialisationPolicy = policy;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public void setExhaustedAction(int exhaustedAction) {
        this.exhaustedAction = exhaustedAction;
    }

    public void setExhaustedActionString(String poolExhaustedAction) {
        if (poolExhaustedAction != null) {
            this.exhaustedAction = "GROW".equalsIgnoreCase(poolExhaustedAction) ? 2 : ("BLOCK".equalsIgnoreCase(poolExhaustedAction) ? 1 : ("FAIL".equalsIgnoreCase(poolExhaustedAction) ? 0 : 1));
        }
    }

    public void setInitialisationPolicyString(String policy) {
        if (policy != null) {
            this.initialisationPolicy = "INITIALISE_NONE".equalsIgnoreCase(policy) ? 0 : ("INITIALISE_ALL".equalsIgnoreCase(policy) ? 2 : 1);
        }
    }

    public UMOPoolFactory getPoolFactory() {
        return this.poolFactory;
    }

    public void setPoolFactory(UMOPoolFactory poolFactory) {
        this.poolFactory = poolFactory;
    }
}

