/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.mule.impl.work.MuleWorkManager;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.util.DisposableThreadPool;

public class ThreadingProfile {
    public static final int WHEN_EXHAUSTED_WAIT = 0;
    public static final int WHEN_EXHAUSTED_DISCARD = 1;
    public static final int WHEN_EXHAUSTED_DISCARD_OLDEST = 2;
    public static final int WHEN_EXHAUSTED_ABORT = 3;
    public static final int WHEN_EXHAUSTED_RUN = 4;
    public static final int DEFAULT_MAX_THREADS_ACTIVE = 10;
    public static final int DEFAULT_MAX_THREADS_IDLE = 10;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 0;
    public static final long DEFAULT_MAX_THREAD_TTL = 60000L;
    public static final boolean DEFAULT_DO_THREADING = true;
    public static final int DEFAULT_POOL_EXHAUST_ACTION = 4;
    private int maxThreadsActive = 10;
    private int maxThreadsIdle = 10;
    private int maxBufferSize = 0;
    private long threadTTL = 60000L;
    private int poolExhaustPolicy = 4;
    private boolean doThreading = true;
    private int threadPriority = 5;
    private WorkManagerFactory workManagerFactory = new DefaultWorkManagerFactory();
    private PooledExecutor.BlockedExecutionHandler blockedExecutionHandler;
    private ThreadFactory threadFactory;

    public ThreadingProfile() {
    }

    public ThreadingProfile(int maxThreadsActive, int maxThreadsIdle, long threadTTL, int poolExhaustPolicy, PooledExecutor.BlockedExecutionHandler blockedExecutionHandler, ThreadFactory threadFactory) {
        this.maxThreadsActive = maxThreadsActive;
        this.maxThreadsIdle = maxThreadsIdle;
        this.threadTTL = threadTTL;
        this.poolExhaustPolicy = poolExhaustPolicy;
        this.blockedExecutionHandler = blockedExecutionHandler;
        this.threadFactory = threadFactory;
    }

    public ThreadingProfile(ThreadingProfile tp) {
        this.maxThreadsActive = tp.getMaxThreadsActive();
        this.maxThreadsIdle = tp.getMaxThreadsIdle();
        this.threadTTL = tp.getThreadTTL();
        this.poolExhaustPolicy = tp.getPoolExhaustedAction();
        this.blockedExecutionHandler = tp.getBlockedExecutionHandler();
        this.threadFactory = tp.getThreadFactory();
        this.workManagerFactory = tp.getWorkManagerFactory();
        this.threadPriority = tp.getThreadPriority();
    }

    public int getMaxThreadsActive() {
        return this.maxThreadsActive;
    }

    public int getMaxThreadsIdle() {
        return this.maxThreadsIdle;
    }

    public long getThreadTTL() {
        return this.threadTTL;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getPoolExhaustedAction() {
        return this.poolExhaustPolicy;
    }

    public PooledExecutor.BlockedExecutionHandler getBlockedExecutionHandler() {
        return this.blockedExecutionHandler;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setMaxThreadsActive(int maxThreadsActive) {
        this.maxThreadsActive = maxThreadsActive;
    }

    public void setMaxThreadsIdle(int maxThreadsIdle) {
        this.maxThreadsIdle = maxThreadsIdle;
    }

    public void setThreadTTL(long threadTTL) {
        this.threadTTL = threadTTL;
    }

    public void setPoolExhaustedAction(int poolExhaustPolicy) {
        this.poolExhaustPolicy = poolExhaustPolicy;
    }

    public void setPoolExhaustedActionString(String poolExhaustPolicy) {
        if (poolExhaustPolicy != null) {
            this.poolExhaustPolicy = "WAIT".equals(poolExhaustPolicy) ? 0 : ("ABORT".equals(poolExhaustPolicy) ? 3 : ("DISCARD".equals(poolExhaustPolicy) ? 1 : ("DISCARD_OLDEST".equals(poolExhaustPolicy) ? 2 : 4)));
        }
    }

    public void setBlockedExecutionHandler(PooledExecutor.BlockedExecutionHandler blockedExecutionHandler) {
        this.blockedExecutionHandler = blockedExecutionHandler;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public WorkManagerFactory getWorkManagerFactory() {
        return this.workManagerFactory;
    }

    public void setWorkManagerFactory(WorkManagerFactory workManagerFactory) {
        this.workManagerFactory = workManagerFactory;
    }

    public UMOWorkManager createWorkManager(String name) {
        return this.workManagerFactory.createWorkManager(this, name);
    }

    public PooledExecutor createPool() {
        return this.configurePool();
    }

    public PooledExecutor createPool(String name) {
        this.threadFactory = new NamedThreadFactory(name, this.threadPriority);
        return this.configurePool();
    }

    public void configurePool(PooledExecutor pool) {
        pool.setMinimumPoolSize(this.maxThreadsIdle);
        pool.setMaximumPoolSize(this.maxThreadsActive);
        pool.setKeepAliveTime(this.threadTTL);
        if (this.blockedExecutionHandler != null) {
            pool.setBlockedExecutionHandler(this.blockedExecutionHandler);
        }
        if (this.threadFactory != null) {
            pool.setThreadFactory(this.threadFactory);
        }
        switch (this.poolExhaustPolicy) {
            case 2: {
                pool.discardOldestWhenBlocked();
                break;
            }
            case 4: {
                pool.runWhenBlocked();
                break;
            }
            case 3: {
                pool.abortWhenBlocked();
                break;
            }
            case 1: {
                pool.discardWhenBlocked();
                break;
            }
            case 0: {
                pool.waitWhenBlocked();
                break;
            }
            default: {
                pool.waitWhenBlocked();
            }
        }
    }

    private PooledExecutor configurePool() {
        DisposableThreadPool pool = this.maxBufferSize > 0 ? new DisposableThreadPool((Channel)new BoundedBuffer(this.maxBufferSize)) : new DisposableThreadPool();
        this.configurePool(pool);
        return pool;
    }

    public boolean isDoThreading() {
        return this.doThreading;
    }

    public void setDoThreading(boolean doThreading) {
        this.doThreading = doThreading;
    }

    public String toString() {
        return "ThreadingProfile{maxThreadsActive=" + this.maxThreadsActive + ", maxThreadsIdle=" + this.maxThreadsIdle + ", maxBufferSize=" + this.maxBufferSize + ", threadTTL=" + this.threadTTL + ", poolExhaustPolicy=" + this.poolExhaustPolicy + ", doThreading=" + this.doThreading + ", threadPriority=" + this.threadPriority + ", workManagerFactory=" + this.workManagerFactory + ", blockedExecutionHandler=" + this.blockedExecutionHandler + ", threadFactory=" + this.threadFactory + "}";
    }

    private class DefaultWorkManagerFactory
    implements WorkManagerFactory {
        private DefaultWorkManagerFactory() {
        }

        public UMOWorkManager createWorkManager(ThreadingProfile profile, String name) {
            return new MuleWorkManager(profile, name);
        }
    }

    public static interface WorkManagerFactory {
        public UMOWorkManager createWorkManager(ThreadingProfile var1, String var2);
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private String name;
        private int priority;
        private int counter = 1;

        public NamedThreadFactory(String name, int priority) {
            this.name = name;
            this.priority = priority;
        }

        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, this.name + "." + this.counter++);
            t.setPriority(this.priority);
            return t;
        }
    }
}

