/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.mbeans;

import java.util.Date;
import org.mule.MuleManager;
import org.mule.management.mbeans.MuleServiceMBean;
import org.mule.umo.UMOException;

public class MuleService
implements MuleServiceMBean {
    private String version;
    private String vendor;

    public boolean isInstanciated() {
        return MuleManager.isInstanciated();
    }

    public boolean isInitialised() {
        return this.isInstanciated() && MuleManager.getInstance().isInitialised();
    }

    public boolean isStopped() {
        return this.isInstanciated() && !MuleManager.getInstance().isStarted();
    }

    public Date getStartTime() {
        if (!this.isStopped()) {
            return new Date(MuleManager.getInstance().getStartDate());
        }
        return null;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = MuleManager.getConfiguration().getProductVersion();
            if (this.version == null) {
                this.version = "Mule Version Info Not Set";
            }
        }
        return this.version;
    }

    public String getVendor() {
        if (this.vendor == null) {
            this.vendor = MuleManager.getConfiguration().getVendorName();
            if (this.vendor == null) {
                this.vendor = "Mule Vendor Info Not Set";
            }
        }
        return this.vendor;
    }

    public void start() throws UMOException {
        MuleManager.getInstance().start();
    }

    public void stop() throws UMOException {
        MuleManager.getInstance().stop();
    }

    public void dispose() throws UMOException {
        MuleManager.getInstance().dispose();
    }

    public boolean isSynchronous() {
        return MuleManager.getConfiguration().isSynchronous();
    }

    public void setSynchronous(boolean synchronous) {
        MuleManager.getConfiguration().setSynchronous(synchronous);
    }

    public int getSynchronousEventTimeout() {
        return MuleManager.getConfiguration().getSynchronousEventTimeout();
    }

    public void setSynchronousEventTimeout(int synchronousEventTimeout) {
        MuleManager.getConfiguration().setSynchronousEventTimeout(synchronousEventTimeout);
    }

    public boolean isSynchronousReceive() {
        return MuleManager.getConfiguration().isSynchronousReceive();
    }

    public boolean isRecoverableMode() {
        return MuleManager.getConfiguration().isRecoverableMode();
    }

    public String getWorkingDirectoy() {
        return MuleManager.getConfiguration().getWorkingDirectoy();
    }

    public String[] getConfigResources() {
        return MuleManager.getConfiguration().getConfigResources();
    }

    public String getServerUrl() {
        return MuleManager.getConfiguration().getServerUrl();
    }
}

