/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public abstract class PollingMessageReceiver
extends AbstractMessageReceiver
implements Work {
    public static final long DEFAULT_POLL_FREQUENCY = 1000L;
    public static final long STARTUP_DELAY = 1000L;
    private long frequency = 1000L;

    public PollingMessageReceiver() {
    }

    public PollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Long frequency) throws InitialisationException {
        this.create(connector, component, endpoint);
        this.frequency = frequency;
        try {
            this.getWorkManager().scheduleWork(this, Long.MAX_VALUE, null, null);
        }
        catch (WorkException e) {
            throw new InitialisationException(new Message(151), e, this);
        }
    }

    public void run() {
        try {
            Thread.sleep(1000L);
            while (!this.connector.isDisposed() && !this.disposing.get()) {
                if (this.connector.isStarted()) {
                    this.poll();
                }
                Thread.sleep(this.frequency);
            }
        }
        catch (Exception e) {
            this.connector.handleException(e);
        }
    }

    public void release() {
        this.dispose();
    }

    public void setFrequency(long l) {
        this.frequency = l <= 0L ? 1000L : l;
    }

    public long getFrequency() {
        return this.frequency;
    }

    protected void doDispose() {
    }

    public abstract void poll() throws Exception;
}

