/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.util.Iterator;
import java.util.List;
import org.mule.providers.PollingMessageReceiver;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionTemplate;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public abstract class TransactedPollingMessageReceiver
extends PollingMessageReceiver {
    protected boolean receiveMessagesInTransaction = true;

    public TransactedPollingMessageReceiver() {
    }

    public TransactedPollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Long frequency) throws InitialisationException {
        super(connector, component, endpoint, frequency);
    }

    public void poll() throws Exception {
        TransactionTemplate tt = new TransactionTemplate(this.endpoint.getTransactionConfig(), this.connector.getExceptionListener());
        if (this.receiveMessagesInTransaction) {
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    List messages = TransactedPollingMessageReceiver.this.getMessages();
                    if (messages != null && messages.size() > 0) {
                        Iterator it = messages.iterator();
                        while (it.hasNext()) {
                            Object message = it.next();
                            if (TransactedPollingMessageReceiver.this.logger.isTraceEnabled()) {
                                TransactedPollingMessageReceiver.this.logger.trace((Object)("Received Message: " + message));
                            }
                            TransactedPollingMessageReceiver.this.processMessage(message);
                        }
                    }
                    return null;
                }
            };
            tt.execute(cb);
        } else {
            List messages = this.getMessages();
            if (messages != null) {
                Iterator it = messages.iterator();
                while (it.hasNext()) {
                    final Object message = it.next();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Received Message: " + message));
                    }
                    TransactionCallback cb = new TransactionCallback(){

                        public Object doInTransaction() throws Exception {
                            TransactedPollingMessageReceiver.this.processMessage(message);
                            return null;
                        }
                    };
                    tt.execute(cb);
                }
            }
        }
    }

    protected abstract List getMessages() throws Exception;

    protected abstract void processMessage(Object var1) throws Exception;
}

