/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.routing.AbstractRouterCollection;
import org.mule.routing.inbound.InboundPassThroughRouter;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOInboundMessageRouter;
import org.mule.umo.routing.UMOInboundRouter;
import org.mule.util.StringMessageHelper;

public class InboundMessageRouter
extends AbstractRouterCollection
implements UMOInboundMessageRouter {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$routing$inbound$InboundMessageRouter == null ? (class$org$mule$routing$inbound$InboundMessageRouter = InboundMessageRouter.class$("org.mule.routing.inbound.InboundMessageRouter")) : class$org$mule$routing$inbound$InboundMessageRouter));
    private List endpoints = new CopyOnWriteArrayList();
    static /* synthetic */ Class class$org$mule$routing$inbound$InboundMessageRouter;

    public InboundMessageRouter() {
        super(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage route(UMOEvent event) throws MessagingException {
        if (this.endpoints.size() > 0 && this.routers.size() == 0) {
            this.addRouter(new InboundPassThroughRouter());
        }
        String componentName = event.getSession().getComponent().getDescriptor().getName();
        UMOEvent[] eventsToRoute = null;
        boolean noRoute = true;
        boolean match = false;
        UMOInboundRouter umoInboundRouter = null;
        Iterator iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            umoInboundRouter = (UMOInboundRouter)iterator.next();
            if (!umoInboundRouter.isMatch(event)) continue;
            match = true;
            eventsToRoute = umoInboundRouter.process(event);
            boolean bl = noRoute = eventsToRoute == null;
            if (this.matchAll) continue;
        }
        if (noRoute) {
            if (this.getStatistics().isEnabled()) {
                this.getStatistics().incrementNoRoutedMessage();
            }
            if (!match) {
                if (this.getCatchAllStrategy() != null) {
                    logger.debug((Object)("Message did not match any routers on: " + componentName + " invoking catch all strategy"));
                    this.getStatistics().incrementCaughtMessage();
                    return this.getCatchAllStrategy().catchMessage(event.getMessage(), event.getSession(), event.isSynchronous());
                }
                logger.warn((Object)("Message did not match any routers on: " + componentName + " and there is no catch all strategy configured on this router.  Disposing message."));
                if (logger.isDebugEnabled()) {
                    try {
                        logger.warn((Object)("Message fragment is: " + StringMessageHelper.truncate(event.getMessageAsString(), 100, true)));
                    }
                    catch (UMOException e) {}
                }
            }
        } else {
            try {
                Object messageResult;
                if (event.isSynchronous()) {
                    messageResult = null;
                    for (int i = 0; i < eventsToRoute.length; ++i) {
                        messageResult = this.send(eventsToRoute[i]);
                        if (!this.getStatistics().isEnabled()) continue;
                        this.getStatistics().incrementRoutedMessage(eventsToRoute[i].getEndpoint());
                    }
                    return messageResult;
                }
                messageResult = eventsToRoute;
                synchronized (eventsToRoute) {
                    for (int i = 0; i < eventsToRoute.length; ++i) {
                        this.dispatch(eventsToRoute[i]);
                        if (!this.getStatistics().isEnabled()) continue;
                        this.getStatistics().incrementRoutedMessage(eventsToRoute[i].getEndpoint());
                    }
                    // ** MonitorExit[messageResult /* !! */ ] (shouldn't be in output)
                    return null;
                }
            }
            catch (UMOException e) {
                throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        return eventsToRoute != null && eventsToRoute.length > 0 ? eventsToRoute[eventsToRoute.length - 1].getMessage() : null;
    }

    public void dispatch(UMOEvent event) throws UMOException {
        event.getSession().dispatchEvent(event);
    }

    public UMOMessage send(UMOEvent event) throws UMOException {
        return event.getSession().sendEvent(event);
    }

    public void addRouter(UMOInboundRouter router) {
        this.routers.add(router);
    }

    public UMOInboundRouter removeRouter(UMOInboundRouter router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("Endpoint cannot be null");
        }
        endpoint.setType("receiver");
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(UMOEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        this.endpoints = endpoints;
    }

    public UMOEndpoint getEndpoint(String name) {
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOEndpoint endpointDescriptor = (UMOEndpoint)iterator.next();
            if (!endpointDescriptor.getName().equals(name)) continue;
            return endpointDescriptor;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

