/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;

public class FilteringListMessageSplitter
extends AbstractMessageSplitter {
    private CopyOnWriteArrayList payload;
    private Map properties;

    protected void initialise(UMOMessage message) {
        if (!(message.getPayload() instanceof List)) {
            throw new IllegalArgumentException("The payload for this router must be of type java.util.list");
        }
        this.payload = new CopyOnWriteArrayList((Collection)((List)message.getPayload()));
        this.properties = message.getProperties();
    }

    protected UMOMessage getMessagePart(UMOMessage message, UMOEndpoint endpoint) {
        MuleMessage result = null;
        for (int i = 0; i < this.payload.size(); ++i) {
            Object object = this.payload.get(i);
            if (endpoint.getFilter() == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("There is not filter configured on: " + endpoint.getEndpointURI().toString() + ". Using endpoint"));
                }
                result = new MuleMessage(object, this.properties);
                this.payload.remove(i);
                break;
            }
            if (!endpoint.getFilter().accept(object)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Endpoint filter matched. Routing message over: " + endpoint.getEndpointURI().toString()));
            }
            result = new MuleMessage(object, this.properties);
            this.payload.remove(i);
            break;
        }
        return result;
    }
}

