/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassHelper {
    public static final Object[] NO_ARGS = new Object[0];
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$util$ClassHelper == null ? (class$org$mule$util$ClassHelper = ClassHelper.class$("org.mule.util.ClassHelper")) : class$org$mule$util$ClassHelper));
    static /* synthetic */ Class class$org$mule$util$ClassHelper;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean isConcrete(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static URL getResource(String resourceName, Class callingClass) {
        URL url = null;
        url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = (class$org$mule$util$ClassHelper == null ? (class$org$mule$util$ClassHelper = ClassHelper.class$("org.mule.util.ClassHelper")) : class$org$mule$util$ClassHelper).getClassLoader().getResource(resourceName);
        }
        if (url == null) {
            url = callingClass.getClassLoader().getResource(resourceName);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) {
        URL url = ClassHelper.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Class loadClass(String className, Class callingClass) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                try {
                    return (class$org$mule$util$ClassHelper == null ? (class$org$mule$util$ClassHelper = ClassHelper.class$("org.mule.util.ClassHelper")) : class$org$mule$util$ClassHelper).getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException exc) {
                    return callingClass.getClassLoader().loadClass(className);
                }
            }
        }
    }

    public static void printClassLoader() {
        System.out.println("ClassLoaderUtils.printClassLoader");
        ClassHelper.printClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static void printClassLoader(ClassLoader cl) {
        System.out.println("ClassLoaderUtils.printClassLoader(cl = " + cl + ")");
        if (cl != null) {
            ClassHelper.printClassLoader(cl.getParent());
        }
    }

    public static Object instanciateClass(Class clazz, Object[] constructorArgs) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor ctor;
        Class[] args = null;
        if (constructorArgs != null) {
            args = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                args[i] = constructorArgs[i] == null ? null : constructorArgs[i].getClass();
            }
        } else {
            args = new Class[]{};
        }
        if ((ctor = ClassHelper.getConstructor(clazz, args)) == null) {
            String argsString = new String();
            for (int i = 0; i < args.length; ++i) {
                argsString = argsString + args[i].getName() + ", ";
            }
            throw new NoSuchMethodException("could not find constructor with matching arg params: " + argsString);
        }
        return ctor.newInstance(constructorArgs);
    }

    public static Object instanciateClass(String name, Object[] constructorArgs) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = ClassHelper.loadClass(name, class$org$mule$util$ClassHelper == null ? (class$org$mule$util$ClassHelper = ClassHelper.class$("org.mule.util.ClassHelper")) : class$org$mule$util$ClassHelper);
        return ClassHelper.instanciateClass(clazz, constructorArgs);
    }

    public static Class[] getParameterTypes(Object bean, String methodName) {
        if (!methodName.startsWith("set")) {
            methodName = "set" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        }
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            return methods[i].getParameterTypes();
        }
        return new Class[0];
    }

    public static Method getMethod(String name, Class clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return methods[i];
        }
        return null;
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes) {
        Constructor<?>[] ctors = clazz.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            if (ctors[i].getParameterTypes().length != paramTypes.length) continue;
            Class<?>[] types = ctors[i].getParameterTypes();
            boolean match = true;
            for (int x = 0; x < types.length; ++x) {
                match = paramTypes[x] == null ? true : types[x].isAssignableFrom(paramTypes[x]);
            }
            if (!match) continue;
            return ctors[i];
        }
        return null;
    }

    public static List getSatisfiableMethods(Class implementation, Class[] parameterTypes, boolean voidOk, boolean ignoreEquals) {
        ArrayList<Method> result = new ArrayList<Method>();
        List<Method> methods = Arrays.asList(implementation.getMethods());
        Iterator<Method> iterator = methods.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            Class[] methodParams = method.getParameterTypes();
            if (!ClassHelper.compare(methodParams, parameterTypes) || (!method.getName().equals("equals") || ignoreEquals) && method.getName().equals("equals") || (!method.getReturnType().getName().equals("void") || !voidOk) && method.getReturnType().getName().equals("void")) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean isClassOnPath(String className, Class currentClass) {
        try {
            return ClassHelper.loadClass(className, currentClass) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class[] getClassTypes(Object object) {
        Class[] types;
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            types = new Class[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                types[i] = objects[i].getClass();
            }
        } else {
            types = new Class[]{object.getClass()};
        }
        return types;
    }

    public static boolean compare(Class[] c1, Class[] c2) {
        if (c1.length != c2.length) {
            return false;
        }
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i].equals(class$java$lang$Object == null ? ClassHelper.class$("java.lang.Object") : class$java$lang$Object) || c1[i].isAssignableFrom(c2[i])) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

