/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.UMODescriptorAware;
import org.mule.model.DynamicEntryPoint;
import org.mule.model.DynamicEntryPointResolver;
import org.mule.umo.Invocation;
import org.mule.umo.MessagingException;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.lifecycle.Stoppable;
import org.mule.umo.lifecycle.UMOLifecycleAdapter;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.util.ClassHelper;

public class DefaultLifecycleAdapter
implements UMOLifecycleAdapter {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$DefaultLifecycleAdapter == null ? (class$org$mule$impl$DefaultLifecycleAdapter = DefaultLifecycleAdapter.class$("org.mule.impl.DefaultLifecycleAdapter")) : class$org$mule$impl$DefaultLifecycleAdapter));
    private Object component;
    private UMODescriptor descriptor;
    private boolean isStoppable = false;
    private boolean isStartable = false;
    private boolean isDisposable = false;
    private boolean started = false;
    private boolean disposed = false;
    private DynamicEntryPoint entryPoint;
    private Object lock = new Object();
    static /* synthetic */ Class class$org$mule$impl$DefaultLifecycleAdapter;
    static /* synthetic */ Class class$org$mule$umo$lifecycle$Startable;
    static /* synthetic */ Class class$org$mule$umo$lifecycle$Stoppable;
    static /* synthetic */ Class class$org$mule$umo$lifecycle$Disposable;
    static /* synthetic */ Class class$org$mule$umo$lifecycle$Initialisable;

    public DefaultLifecycleAdapter(Object component, UMODescriptor descriptor) throws UMOException {
        this(component, descriptor, new DynamicEntryPointResolver());
    }

    public DefaultLifecycleAdapter(Object component, UMODescriptor descriptor, UMOEntryPointResolver epResolver) throws UMOException {
        this.initialise(component, descriptor, epResolver);
    }

    protected void initialise(Object component, UMODescriptor descriptor, UMOEntryPointResolver epDiscovery) throws UMOException {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        if (epDiscovery == null) {
            epDiscovery = new DynamicEntryPointResolver();
        }
        this.component = component;
        this.entryPoint = (DynamicEntryPoint)epDiscovery.resolveEntryPoint(descriptor);
        this.descriptor = descriptor;
        this.isStartable = (class$org$mule$umo$lifecycle$Startable == null ? (class$org$mule$umo$lifecycle$Startable = DefaultLifecycleAdapter.class$("org.mule.umo.lifecycle.Startable")) : class$org$mule$umo$lifecycle$Startable).isInstance(component);
        this.isStoppable = (class$org$mule$umo$lifecycle$Stoppable == null ? (class$org$mule$umo$lifecycle$Stoppable = DefaultLifecycleAdapter.class$("org.mule.umo.lifecycle.Stoppable")) : class$org$mule$umo$lifecycle$Stoppable).isInstance(component);
        this.isDisposable = (class$org$mule$umo$lifecycle$Disposable == null ? (class$org$mule$umo$lifecycle$Disposable = DefaultLifecycleAdapter.class$("org.mule.umo.lifecycle.Disposable")) : class$org$mule$umo$lifecycle$Disposable).isInstance(component);
        if (component instanceof UMODescriptorAware) {
            ((UMODescriptorAware)component).setDescriptor(descriptor);
        }
    }

    public void start() throws UMOException {
        if (this.isStartable) {
            try {
                ((Startable)this.component).start();
            }
            catch (Exception e) {
                throw new MuleException(new Message(42, "UMO Component: " + this.descriptor.getName()), (Throwable)e);
            }
        }
        this.started = true;
    }

    public void stop() throws UMOException {
        if (this.isStoppable) {
            try {
                ((Stoppable)this.component).stop();
            }
            catch (Exception e) {
                throw new MuleException(new Message(41, "UMO Component: " + this.descriptor.getName()), (Throwable)e);
            }
        }
        this.started = false;
    }

    public void dispose() {
        if (this.isDisposable) {
            try {
                ((Disposable)this.component).dispose();
            }
            catch (Exception e) {
                logger.error((Object)("failed to dispose: " + this.descriptor.getName()), (Throwable)e);
            }
        }
        this.disposed = true;
    }

    public Object onCall(UMOEvent event) throws UMOException {
        Object result = null;
        try {
            Object methodOverride = event.removeProperty("MULE_METHOD");
            Method method = null;
            if (methodOverride instanceof Method) {
                method = (Method)methodOverride;
            } else if (methodOverride != null) {
                method = ClassHelper.getMethod(methodOverride.toString(), this.component.getClass());
            }
            result = this.entryPoint.invoke(this.component, RequestContext.getEventContext(), method);
            UMOMessage resultMessage = null;
            if (result == null && this.entryPoint.isVoid()) {
                resultMessage = new MuleMessage(event.getTransformedMessage(), event.getProperties());
            } else if (result != null) {
                resultMessage = result instanceof UMOMessage ? (UMOMessage)result : new MuleMessage(result, event.getProperties());
            }
            boolean stopProcessing = false;
            stopProcessing = this.descriptor.getResponseRouter() != null ? this.descriptor.getResponseRouter().isStopProcessing() : event.isStopFurtherProcessing();
            if (this.descriptor.getResponseRouter() != null) {
                if (event.isSynchronous() && !stopProcessing) {
                    stopProcessing = true;
                    this.descriptor.getOutboundRouter().route(resultMessage, event.getSession(), false);
                }
                logger.debug((Object)"Waiting for response router message");
                result = this.descriptor.getResponseRouter().getResponse(resultMessage);
                if (stopProcessing) {
                    logger.debug((Object)"Setting stop oubound processing according to response router");
                    RequestContext.getEvent().setStopFurtherProcessing(true);
                }
                return result;
            }
            return resultMessage;
        }
        catch (Exception e) {
            throw new MessagingException(new Message(68, "UMO Component: " + this.descriptor.getName()), event.getMessage(), (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public UMODescriptor getDescriptor() {
        return this.descriptor;
    }

    public void handleException(Object message, Exception e) {
        this.descriptor.getExceptionListener().exceptionThrown(e);
    }

    public UMOMessage intercept(Invocation invocation) throws UMOException {
        UMOEvent currentEvent = RequestContext.getEvent();
        Object result = this.onCall(currentEvent);
        if (result instanceof UMOMessage) {
            return (UMOMessage)result;
        }
        if (result instanceof UMOEvent) {
            return ((UMOEvent)result).getMessage();
        }
        if (result != null) {
            return new MuleMessage(result, currentEvent.getProperties());
        }
        return null;
    }

    public void initialise() throws InitialisationException {
        if ((class$org$mule$umo$lifecycle$Initialisable == null ? (class$org$mule$umo$lifecycle$Initialisable = DefaultLifecycleAdapter.class$("org.mule.umo.lifecycle.Initialisable")) : class$org$mule$umo$lifecycle$Initialisable).isInstance(this.component)) {
            ((Initialisable)this.component).initialise();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

