/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.beans.ExceptionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.MuleConfiguration;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.impl.ImmutableMuleDescriptor;
import org.mule.impl.InitialisationCallback;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.routing.inbound.InboundMessageRouter;
import org.mule.routing.inbound.InboundPassThroughRouter;
import org.mule.routing.outbound.OutboundMessageRouter;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.routing.UMOInboundMessageRouter;
import org.mule.umo.routing.UMOOutboundMessageRouter;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOResponseMessageRouter;
import org.mule.umo.transformer.UMOTransformer;

public class MuleDescriptor
extends ImmutableMuleDescriptor
implements UMODescriptor {
    public static final String DEFAULT_INSTANCE_REF_NAME = "_instanceRef";
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$MuleDescriptor == null ? (class$org$mule$impl$MuleDescriptor = MuleDescriptor.class$("org.mule.impl.MuleDescriptor")) : class$org$mule$impl$MuleDescriptor));
    static /* synthetic */ Class class$org$mule$impl$MuleDescriptor;

    public MuleDescriptor(String name) {
        this.name = name;
    }

    public MuleDescriptor(MuleDescriptor descriptor) {
        super(descriptor);
    }

    public MuleDescriptor() {
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    public void setExceptionListener(ExceptionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Exception Strategy cannot be null");
        }
        this.exceptionListener = listener;
        logger.debug((Object)("Using exception strategy: " + listener.getClass().getName()));
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = newName;
    }

    public void setOutboundTransformer(UMOTransformer transformer) {
        this.outboundTransformer = transformer;
    }

    public void setResponseTransformer(UMOTransformer transformer) {
        this.responseTransformer = transformer;
    }

    public void setProperties(Map props) {
        this.properties = props;
        String delegate = (String)this.properties.get("org.mule.dotProperties");
        if (delegate != null) {
            try {
                FileInputStream is = new FileInputStream(new File(delegate));
                Properties dProps = new Properties();
                dProps.load(is);
                this.properties.putAll(dProps);
            }
            catch (Exception e) {
                logger.warn((Object)("org.mule.dotProperties was set  to " + delegate + " but the file could not be read, exception is: " + e.getMessage()));
            }
        }
    }

    public void setVersion(String ver) {
        this.version = ver;
    }

    public void setInboundEndpoint(UMOEndpoint endpoint) throws MuleException {
        this.inboundEndpoint = endpoint;
        if (this.inboundEndpoint != null) {
            this.inboundEndpoint.setType("receiver");
            if (this.inboundEndpoint.getTransformer() != null) {
                this.inboundTransformer = this.inboundEndpoint.getTransformer();
            }
        }
    }

    public void setOutboundEndpoint(UMOEndpoint endpoint) throws MuleException {
        this.outboundEndpoint = endpoint;
        if (this.outboundEndpoint != null) {
            this.outboundEndpoint.setType("sender");
            if (this.outboundEndpoint.getTransformer() != null) {
                this.outboundTransformer = this.outboundEndpoint.getTransformer();
            }
        }
    }

    public void setInboundTransformer(UMOTransformer transformer) {
        this.inboundTransformer = transformer;
    }

    public void addInterceptor(UMOInterceptor inteceptor) {
        if (inteceptor != null) {
            this.intecerptorList.add(inteceptor);
        }
    }

    public void setInterceptors(List inteceptorList) {
        this.intecerptorList = inteceptorList;
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public void setImplementation(Object reference) {
        if (reference == null) {
            throw new IllegalArgumentException("ImplementationReference cannot be null");
        }
        this.implementationReference = reference;
    }

    public void setImplementationInstance(Object instance) {
        this.properties.put(DEFAULT_INSTANCE_REF_NAME, instance);
        this.setImplementation("local:_instanceRef");
    }

    public void setInboundRouter(UMOInboundMessageRouter routerList) {
        this.inboundRouter = routerList;
    }

    public void setOutboundRouter(UMOOutboundMessageRouter routerList) {
        this.outboundRouter = routerList;
    }

    public void setContainerManaged(boolean value) {
        this.containerManaged = value;
    }

    public void initialise() throws InitialisationException {
        MuleEndpoint endpoint;
        Iterator iterator;
        MuleConfiguration config = MuleManager.getConfiguration();
        if (this.threadingProfile == null) {
            this.threadingProfile = config.getComponentThreadingProfile();
        }
        if (this.poolingProfile == null) {
            this.poolingProfile = config.getPoolingProfile();
        }
        if (this.queueProfile == null) {
            this.queueProfile = config.getQueueProfile();
        }
        if (this.exceptionListener == null) {
            this.exceptionListener = MuleManager.getInstance().getModel().getExceptionListener();
        } else if (this.exceptionListener instanceof Initialisable) {
            ((Initialisable)((Object)this.exceptionListener)).initialise();
        }
        if (this.inboundEndpoint != null) {
            if (this.inboundTransformer != null) {
                this.inboundEndpoint.setTransformer(this.inboundTransformer);
            }
            ((MuleEndpoint)this.inboundEndpoint).initialise();
            if (this.inboundTransformer == null) {
                this.inboundTransformer = this.inboundEndpoint.getTransformer();
            }
        }
        if (this.outboundEndpoint != null) {
            if (this.outboundTransformer != null) {
                this.outboundEndpoint.setTransformer(this.outboundTransformer);
            }
            ((MuleEndpoint)this.outboundEndpoint).initialise();
            if (this.outboundTransformer == null) {
                this.outboundTransformer = this.outboundEndpoint.getTransformer();
            }
        }
        if (this.exceptionListener instanceof Initialisable) {
            ((Initialisable)((Object)this.exceptionListener)).initialise();
        }
        if (this.inboundRouter == null) {
            this.inboundRouter = new InboundMessageRouter();
            this.inboundRouter.addRouter(new InboundPassThroughRouter());
        } else {
            if (this.inboundRouter.getCatchAllStrategy() != null && this.inboundRouter.getCatchAllStrategy().getEndpoint() != null) {
                ((MuleEndpoint)this.inboundRouter.getCatchAllStrategy().getEndpoint()).initialise();
            }
            iterator = this.inboundRouter.getEndpoints().iterator();
            while (iterator.hasNext()) {
                endpoint = (MuleEndpoint)iterator.next();
                endpoint.initialise();
            }
        }
        if (this.responseRouter != null) {
            iterator = this.responseRouter.getEndpoints().iterator();
            while (iterator.hasNext()) {
                endpoint = (MuleEndpoint)iterator.next();
                endpoint.initialise();
            }
        }
        if (this.outboundRouter == null) {
            this.outboundRouter = new OutboundMessageRouter();
            this.outboundRouter.addRouter(new OutboundPassThroughRouter(this));
        } else {
            if (this.outboundRouter.getCatchAllStrategy() != null && this.outboundRouter.getCatchAllStrategy().getEndpoint() != null) {
                ((MuleEndpoint)this.outboundRouter.getCatchAllStrategy().getEndpoint()).initialise();
            }
            UMOOutboundRouter router = null;
            Iterator iterator2 = this.outboundRouter.getRouters().iterator();
            while (iterator2.hasNext()) {
                router = (UMOOutboundRouter)iterator2.next();
                Iterator iterator1 = router.getEndpoints().iterator();
                while (iterator1.hasNext()) {
                    endpoint = (MuleEndpoint)iterator1.next();
                    endpoint.initialise();
                }
            }
        }
    }

    public void addInitialisationCallback(InitialisationCallback callback) {
        this.initialisationCallbacks.add(callback);
    }

    public void setResponseRouter(UMOResponseMessageRouter router) {
        this.responseRouter = router;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

