/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.container;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.util.ChainedReader;

public abstract class AbstractContainerContext
implements UMOContainerContext {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String name;

    protected AbstractContainerContext(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void initialise() throws InitialisationException {
    }

    public void dispose() {
    }

    public final void configure(Reader configuration, String doctype, String encoding) throws ContainerException {
        String decl = this.getXmlDeclaration(encoding);
        this.logger.debug((Object)("Using Xml declaration: " + decl));
        if (doctype == null) {
            doctype = this.getDefaultDocType();
        }
        if (doctype != null) {
            if (!doctype.startsWith("<!DOCTYPE")) {
                doctype = "<!DOCTYPE " + doctype + ">";
            }
            this.logger.info((Object)("Using doctype: " + doctype));
        } else {
            doctype = "";
        }
        StringReader declaration = new StringReader(decl + "\n" + doctype);
        ChainedReader reader = new ChainedReader(declaration, configuration);
        this.configure(reader);
    }

    protected String getXmlDeclaration(String encoding) {
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return "<?xml version=\"1.0\" encoding=\"" + encoding.toUpperCase() + "\"?>";
    }

    protected String getDefaultDocType() {
        return null;
    }

    protected String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    public abstract void configure(Reader var1) throws ContainerException;
}

