/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.work;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ThreadingProfile;
import org.mule.impl.work.NullWorkExecutorPool;
import org.mule.impl.work.ScheduleWorkExecutor;
import org.mule.impl.work.StartWorkExecutor;
import org.mule.impl.work.SyncWorkExecutor;
import org.mule.impl.work.WorkExecutor;
import org.mule.impl.work.WorkExecutorPool;
import org.mule.impl.work.WorkerContext;
import org.mule.umo.UMOException;
import org.mule.umo.manager.UMOWorkManager;

public class MuleWorkManager
implements UMOWorkManager {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$work$MuleWorkManager == null ? (class$org$mule$impl$work$MuleWorkManager = MuleWorkManager.class$("org.mule.impl.work.MuleWorkManager")) : class$org$mule$impl$work$MuleWorkManager));
    private WorkExecutorPool syncWorkExecutorPool;
    private WorkExecutorPool startWorkExecutorPool;
    private WorkExecutorPool scheduledWorkExecutorPool;
    private final WorkExecutor scheduleWorkExecutor = new ScheduleWorkExecutor();
    private final WorkExecutor startWorkExecutor = new StartWorkExecutor();
    private final WorkExecutor syncWorkExecutor = new SyncWorkExecutor();
    static /* synthetic */ Class class$org$mule$impl$work$MuleWorkManager;

    public MuleWorkManager() {
        this(MuleManager.getConfiguration().getDefaultThreadingProfile(), null);
    }

    public MuleWorkManager(ThreadingProfile profile, String name) {
        if (name == null) {
            name = "WorkManager#" + this.hashCode();
        }
        this.syncWorkExecutorPool = new NullWorkExecutorPool(profile, name);
        this.startWorkExecutorPool = new NullWorkExecutorPool(profile, name);
        this.scheduledWorkExecutorPool = new NullWorkExecutorPool(profile, name);
    }

    public void start() throws UMOException {
        this.syncWorkExecutorPool = this.syncWorkExecutorPool.start();
        this.startWorkExecutorPool = this.startWorkExecutorPool.start();
        this.scheduledWorkExecutorPool = this.scheduledWorkExecutorPool.start();
    }

    public void stop() throws UMOException {
        this.syncWorkExecutorPool = this.syncWorkExecutorPool.stop();
        this.startWorkExecutorPool = this.startWorkExecutorPool.stop();
        this.scheduledWorkExecutorPool = this.scheduledWorkExecutorPool.stop();
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (UMOException e) {
            logger.warn((Object)("Error while disposing Work Manager: " + e.getMessage()), (Throwable)e);
        }
    }

    public XATerminator getXATerminator() {
        return null;
    }

    public int getSyncThreadCount() {
        return this.syncWorkExecutorPool.getPoolSize();
    }

    public int getSyncMaximumPoolSize() {
        return this.syncWorkExecutorPool.getMaximumPoolSize();
    }

    public void setSyncMaximumPoolSize(int maxSize) {
        this.syncWorkExecutorPool.setMaximumPoolSize(maxSize);
    }

    public int getStartThreadCount() {
        return this.startWorkExecutorPool.getPoolSize();
    }

    public int getStartMaximumPoolSize() {
        return this.startWorkExecutorPool.getMaximumPoolSize();
    }

    public void setStartMaximumPoolSize(int maxSize) {
        this.startWorkExecutorPool.setMaximumPoolSize(maxSize);
    }

    public int getScheduledThreadCount() {
        return this.scheduledWorkExecutorPool.getPoolSize();
    }

    public int getScheduledMaximumPoolSize() {
        return this.scheduledWorkExecutorPool.getMaximumPoolSize();
    }

    public void setScheduledMaximumPoolSize(int maxSize) {
        this.scheduledWorkExecutorPool.setMaximumPoolSize(maxSize);
    }

    public void doWork(Work work) throws WorkException {
        this.executeWork(new WorkerContext(work), this.syncWorkExecutor, this.syncWorkExecutorPool);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.syncWorkExecutor, this.syncWorkExecutorPool);
    }

    public long startWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor, this.startWorkExecutorPool);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor, this.startWorkExecutorPool);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public void scheduleWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor, this.scheduledWorkExecutorPool);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor, this.scheduledWorkExecutorPool);
    }

    private void executeWork(WorkerContext work, WorkExecutor workExecutor, Executor pooledExecutor) throws WorkException {
        work.workAccepted(this);
        try {
            workExecutor.doExecute(work, pooledExecutor);
            WorkException exception = work.getWorkException();
            if (null != exception) {
                throw exception;
            }
        }
        catch (InterruptedException e) {
            WorkCompletedException wcj = new WorkCompletedException("The execution has been interrupted.", (Throwable)e);
            wcj.setErrorCode("-1");
            throw wcj;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

