/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.mbeans;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mule.MuleManager;
import org.mule.impl.MuleComponent;
import org.mule.management.mbeans.ComponentServiceMBean;
import org.mule.management.mbeans.ComponentStats;
import org.mule.umo.UMOException;
import org.mule.umo.UMOSession;

public class ComponentService
implements ComponentServiceMBean,
MBeanRegistration {
    private MBeanServer server;
    private String name;
    private ObjectName statsName;
    private ObjectName objectName;

    public ComponentService(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getQueueSize() {
        return this.getComponent().getQueueSize();
    }

    public void pause() throws UMOException {
        this.getComponent().pause();
    }

    public void resume() throws UMOException {
        this.getComponent().resume();
    }

    public boolean isPaused() {
        return this.getComponent().isPaused();
    }

    public boolean isStopped() {
        return this.getComponent().isStopped();
    }

    public void stop() throws UMOException {
        this.getComponent().stop();
    }

    public void dispose() throws UMOException {
        this.getComponent().dispose();
    }

    public void start() throws UMOException {
        this.getComponent().start();
    }

    public ObjectName getStatistics() {
        return this.statsName;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        try {
            if (this.getComponent().getStatistics() != null) {
                this.statsName = new ObjectName(this.objectName.getDomain() + ":type=statistics,name=" + this.getName());
                this.server.registerMBean(new ComponentStats(this.getComponent().getStatistics()), this.statsName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    private MuleComponent getComponent() {
        UMOSession session = MuleManager.getInstance().getModel().getComponentSession(this.getName());
        if (session == null) {
            return null;
        }
        return (MuleComponent)session.getComponent();
    }
}

