/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.mbeans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.management.mbeans.EndpointServiceMBean;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UMOMessageReceiver;

public class EndpointService
implements EndpointServiceMBean {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private UMOEndpoint endpoint;
    private UMOMessageReceiver receiver;

    public EndpointService(UMOEndpoint endpoint) {
        this.endpoint = endpoint;
        this.init();
    }

    public EndpointService(UMOMessageReceiver receiver) {
        if (receiver == null) {
            throw new NullPointerException(new Message(45, "Receiver").getMessage());
        }
        this.endpoint = receiver.getEndpoint();
        this.receiver = receiver;
        this.init();
    }

    private void init() {
        if (this.endpoint == null) {
            throw new NullPointerException(new Message(45, "Endpoint").getMessage());
        }
        if (this.receiver == null && !"receiver".equals(this.endpoint.getType())) {
            throw new IllegalArgumentException("Recevier is null for Endpoint MBean but the endpoint itself is a receiving endpoint");
        }
    }

    public String getAddress() {
        return this.endpoint.getEndpointURI().getAddress();
    }

    public String getName() {
        return this.endpoint.getName().replaceAll(":", "#");
    }

    public boolean isConnected() {
        if (this.receiver == null) {
            return true;
        }
        return this.receiver.isConnected();
    }

    public void connect() throws Exception {
        if (this.receiver != null && !this.receiver.isConnected()) {
            this.receiver.connect();
        } else {
            this.logger.debug((Object)"Endpoint is already connected");
        }
    }

    public void disconnect() throws Exception {
        if (this.receiver != null && this.receiver.isConnected()) {
            this.receiver.disconnect();
        } else {
            this.logger.debug((Object)"Endpoint is already disconnected");
        }
    }

    public boolean isSynchronous() {
        return this.endpoint.isSynchronous();
    }

    public String getType() {
        return this.endpoint.getType();
    }
}

