/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.FatalConnectException;

public abstract class AbstractConnectionStrategy
implements ConnectionStrategy {
    private boolean doThreading = false;

    public final void connect(final AbstractMessageReceiver receiver) throws FatalConnectException {
        if (this.doThreading) {
            try {
                receiver.getWorkManager().scheduleWork(new Work(){

                    public void release() {
                    }

                    public void run() {
                        try {
                            AbstractConnectionStrategy.this.doConnect(receiver);
                        }
                        catch (FatalConnectException e) {
                            receiver.handleException(e);
                        }
                    }
                });
            }
            catch (WorkException e) {
                receiver.handleException((Exception)((Object)e));
            }
        } else {
            this.doConnect(receiver);
        }
    }

    public boolean isDoThreading() {
        return this.doThreading;
    }

    public void setDoThreading(boolean doThreading) {
        this.doThreading = doThreading;
    }

    public abstract void doConnect(AbstractMessageReceiver var1) throws FatalConnectException;
}

