/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.AlreadyInitialisedException;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.management.mbeans.EndpointService;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.DefaultReplyToHandler;
import org.mule.providers.ReplyToHandler;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.DisposeException;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerEvent;
import org.mule.umo.provider.ConnectorException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.provider.UMOMessageDispatcherFactory;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractConnector
implements UMOConnector,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected SynchronizedBoolean started = new SynchronizedBoolean(false);
    protected SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    protected String name = null;
    protected ExceptionListener exceptionListener = null;
    protected SynchronizedBoolean disposed = new SynchronizedBoolean(false);
    protected UMOMessageDispatcherFactory dispatcherFactory;
    protected Map dispatchers;
    protected ConcurrentHashMap receivers;
    private ThreadingProfile dispatcherThreadingProfile = null;
    private ThreadingProfile receiverThreadingProfile = null;
    private boolean disposeDispatcherOnCompletion = false;
    protected UMOTransformer defaultInboundTransformer = null;
    protected UMOTransformer defaultOutboundTransformer = null;
    protected UMOTransformer defaultResponseTransformer = null;
    private ConnectionStrategy connectionStrategy;

    public AbstractConnector() {
        this.exceptionListener = new DefaultExceptionStrategy();
        this.dispatchers = new ConcurrentHashMap();
        this.receivers = new ConcurrentHashMap();
        this.connectionStrategy = MuleManager.getConfiguration().getConnectionStrategy();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Connector name cannot be null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set UMOConnector name to: " + newName));
        }
        this.name = newName;
    }

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new AlreadyInitialisedException("Connector '" + this.getName() + "'", (Object)this);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initialising " + this.getClass().getName()));
        }
        if (this.exceptionListener instanceof Initialisable) {
            ((Initialisable)((Object)this.exceptionListener)).initialise();
        }
        this.doInitialise();
        this.initialised.set(true);
    }

    public abstract String getProtocol();

    public final void start() throws UMOException {
        if (this.isDisposed()) {
            throw new ConnectorException(new Message(32), this);
        }
        if (!this.started.get()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Starting Connector: " + this.getClass().getName()));
            }
            this.doStart();
            Iterator iterator = this.receivers.values().iterator();
            while (iterator.hasNext()) {
                AbstractMessageReceiver amr = (AbstractMessageReceiver)iterator.next();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Starting receiver on endpoint: " + amr.getEndpoint().getEndpointURI()));
                }
                amr.start();
            }
            this.started.set(true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Connector: " + this.getClass().getName() + " has been started"));
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public final void stop() throws UMOException {
        if (this.isDisposed()) {
            return;
        }
        if (this.started.get()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Stopping Connector: " + this.getClass().getName()));
            }
            this.doStop();
            Iterator iterator = this.receivers.values().iterator();
            while (iterator.hasNext()) {
                AbstractMessageReceiver amr = (AbstractMessageReceiver)iterator.next();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Stopping receiver on endpoint: " + amr.getEndpoint().getEndpointURI()));
                }
                amr.stop();
            }
            this.started.set(false);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Connector " + this.getClass().getName() + " has been stopped"));
            }
        }
    }

    public final synchronized void dispose() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposing Connector: " + this.getClass().getName()));
            this.logger.debug((Object)"Disposing Receivers");
        }
        if (this.receivers != null) {
            Iterator iterator = this.receivers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                try {
                    this.destroyReceiver((UMOMessageReceiver)entry.getValue(), null);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to destroy receiver: " + e.getMessage()), (Throwable)e);
                }
                this.receivers.remove(entry.getKey());
            }
            this.logger.debug((Object)"Receivers Disposed");
        }
        if (this.dispatchers != null) {
            this.logger.debug((Object)"Disposing Dispatchers");
            Iterator iterator = this.dispatchers.values().iterator();
            while (iterator.hasNext()) {
                UMOMessageDispatcher umoMessageDispatcher = (UMOMessageDispatcher)iterator.next();
                umoMessageDispatcher.dispose();
            }
            this.dispatchers.clear();
            this.logger.debug((Object)"Dispatchers Disposed");
        }
        this.doDispose();
        this.disposed.set(true);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Connector " + this.getClass().getName() + " has been disposed."));
        }
        this.receivers = null;
        this.dispatchers = null;
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public void handleException(Exception exception) {
        if (this.exceptionListener == null) {
            throw new MuleRuntimeException(new Message(146, this.getName()), (Throwable)exception);
        }
        this.exceptionListener.exceptionThrown(exception);
    }

    public void exceptionThrown(Exception e) {
        this.handleException(e);
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public UMOMessageDispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public void setDispatcherFactory(UMOMessageDispatcherFactory dispatcerFactory) {
        this.dispatcherFactory = dispatcerFactory;
    }

    public synchronized UMOMessageDispatcher getDispatcher(String endpoint) throws UMOException {
        this.checkDisposed();
        UMOMessageDispatcher dispatcher = null;
        if (endpoint == null || "".equals(endpoint)) {
            endpoint = "ANY";
        }
        if ("ANY".equals(endpoint) && this.dispatchers.size() > 0) {
            Iterator iterator = this.dispatchers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((UMOMessageDispatcher)entry.getValue()).isDisposed()) {
                    this.dispatchers.remove(entry.getKey());
                    continue;
                }
                dispatcher = (UMOMessageDispatcher)entry.getValue();
                break;
            }
        } else {
            if (this.dispatchers == null) {
                throw new NullPointerException("Dispatchers are null for connector: " + this.name);
            }
            dispatcher = (UMOMessageDispatcher)this.dispatchers.get(endpoint);
            if (dispatcher != null && dispatcher.isDisposed()) {
                this.dispatchers.values().remove(dispatcher);
                dispatcher = null;
            }
        }
        if (dispatcher == null) {
            dispatcher = this.createDispatcher();
            this.dispatchers.put(endpoint, dispatcher);
        }
        return dispatcher;
    }

    protected void checkDisposed() throws DisposeException {
        if (this.isDisposed()) {
            throw new DisposeException(new Message(32), (Object)this);
        }
    }

    protected UMOMessageDispatcher createDispatcher() throws UMOException {
        if (this.dispatcherFactory == null) {
            throw new ConnectorException(new Message(36, this.name), this);
        }
        UMOMessageDispatcher dispatcher = this.dispatcherFactory.create(this);
        return dispatcher;
    }

    public UMOMessageReceiver registerListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (endpoint == null || component == null) {
            throw new IllegalArgumentException("The endpoint and component cannot be null when registering a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new ConnectorException(new Message(34), this);
        }
        this.logger.info((Object)("registering listener: " + component.getDescriptor().getName() + " on endpointUri: " + endpointUri.toString()));
        UMOMessageReceiver receiver = (UMOMessageReceiver)this.receivers.get(this.getReceiverKey(component, endpoint));
        if (receiver != null) {
            throw new ConnectorException(new Message(35, endpointUri), this);
        }
        receiver = this.createReceiver(component, endpoint);
        this.receivers.put(this.getReceiverKey(component, endpoint), (Object)receiver);
        if (this.started.get()) {
            ((AbstractMessageReceiver)receiver).start();
        }
        return receiver;
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        if (endpoint.getEndpointURI().getFilterAddress() != null) {
            return endpoint.getEndpointURI().getFilterAddress();
        }
        return endpoint.getEndpointURI().getAddress();
    }

    public final void unregisterListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        UMOMessageReceiver receiver;
        if (endpoint == null || component == null || endpoint.getEndpointURI() == null) {
            throw new IllegalArgumentException("The endpoint and component and endpointUri cannot be null when you unregister a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("removing listener on endpointUri: " + endpointUri));
        }
        if ((receiver = (UMOMessageReceiver)this.receivers.remove(this.getReceiverKey(component, endpoint))) != null) {
            this.destroyReceiver(receiver, endpoint);
            receiver.dispose();
        }
    }

    public ThreadingProfile getDispatcherThreadingProfile() {
        if (this.dispatcherThreadingProfile == null) {
            this.dispatcherThreadingProfile = MuleManager.getConfiguration().getMessageDispatcherThreadingProfile();
        }
        return this.dispatcherThreadingProfile;
    }

    public void setDispatcherThreadingProfile(ThreadingProfile dispatcherThreadingProfile) {
        this.dispatcherThreadingProfile = dispatcherThreadingProfile;
    }

    public ThreadingProfile getReceiverThreadingProfile() {
        if (this.receiverThreadingProfile == null) {
            this.receiverThreadingProfile = MuleManager.getConfiguration().getMessageReceiverThreadingProfile();
        }
        return this.receiverThreadingProfile;
    }

    public void setReceiverThreadingProfile(ThreadingProfile receiverThreadingProfile) {
        this.receiverThreadingProfile = receiverThreadingProfile;
    }

    public abstract UMOMessageReceiver createReceiver(UMOComponent var1, UMOEndpoint var2) throws Exception;

    public void destroyReceiver(UMOMessageReceiver receiver, UMOEndpoint endpoint) throws Exception {
        receiver.dispose();
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    protected void doDispose() {
        try {
            this.stop();
        }
        catch (UMOException e) {
            this.logger.warn((Object)("Failed to stop during shutdown: " + e.getMessage()), (Throwable)e);
        }
    }

    public void doInitialise() throws InitialisationException {
    }

    public UMOTransformer getDefaultInboundTransformer() {
        if (this.defaultInboundTransformer != null) {
            try {
                return (UMOTransformer)this.defaultInboundTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Inbound transformer");
                return null;
            }
        }
        return null;
    }

    public void setDefaultInboundTransformer(UMOTransformer defaultInboundTransformer) {
        this.defaultInboundTransformer = defaultInboundTransformer;
    }

    public UMOTransformer getDefaultResponseTransformer() {
        if (this.defaultResponseTransformer != null) {
            try {
                return (UMOTransformer)this.defaultResponseTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Outbound transformer");
                return null;
            }
        }
        return null;
    }

    public UMOTransformer getDefaultOutboundTransformer() {
        if (this.defaultOutboundTransformer != null) {
            try {
                return (UMOTransformer)this.defaultOutboundTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Outbound transformer");
                return null;
            }
        }
        return null;
    }

    public void setDefaultOutboundTransformer(UMOTransformer defaultOutboundTransformer) {
        this.defaultOutboundTransformer = defaultOutboundTransformer;
    }

    public void setDefaultResponseTransformer(UMOTransformer defaultResponseTransformer) {
        this.defaultResponseTransformer = defaultResponseTransformer;
    }

    public ReplyToHandler getReplyToHandler() {
        return new DefaultReplyToHandler(this.defaultResponseTransformer);
    }

    public Map getDispatchers() {
        return this.dispatchers;
    }

    public void fireEvent(UMOServerEvent event) {
        MuleManager.getInstance().fireEvent(event);
    }

    public ConnectionStrategy getConnectionStrategy() {
        try {
            return (ConnectionStrategy)BeanUtils.cloneBean((Object)this.connectionStrategy);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(new Message(145, "connectionStrategy"), (Throwable)e);
        }
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public List getEndpointMBeans() {
        ArrayList<EndpointService> beans = new ArrayList<EndpointService>(this.receivers.size());
        Iterator iterator = this.receivers.values().iterator();
        while (iterator.hasNext()) {
            UMOMessageReceiver receiver = (UMOMessageReceiver)iterator.next();
            beans.add(new EndpointService(receiver));
        }
        return beans;
    }
}

