/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ExceptionHelper;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleSession;
import org.mule.impl.RequestContext;
import org.mule.impl.ResponseOutputStream;
import org.mule.impl.internal.events.ConnectionEvent;
import org.mule.impl.internal.events.SecurityEvent;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ConnectException;
import org.mule.providers.ConnectionStrategy;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.umo.security.SecurityException;

public abstract class AbstractMessageReceiver
implements UMOMessageReceiver {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOComponent component = null;
    protected UMOEndpoint endpoint = null;
    protected UMOModel model = null;
    protected AbstractConnector connector = null;
    protected boolean serverSide = true;
    protected SynchronizedBoolean disposing = new SynchronizedBoolean(false);
    protected SynchronizedBoolean connected = new SynchronizedBoolean(false);
    protected SynchronizedBoolean stopped = new SynchronizedBoolean(true);
    private boolean connecting = false;
    private UMOEndpointURI endpointUri;
    private UMOWorkManager workManager;
    private ConnectionStrategy connectionStrategy;
    static /* synthetic */ Class class$org$mule$providers$AbstractConnector;

    public AbstractMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        this.setConnector(connector);
        this.setComponent(component);
        this.setEndpoint(endpoint);
        this.endpointUri = endpoint.getEndpointURI();
        this.model = MuleManager.getInstance().getModel();
        if (connector instanceof AbstractConnector) {
            ThreadingProfile tp = ((AbstractConnector)connector).getReceiverThreadingProfile();
            if (this.serverSide) {
                tp.setThreadPriority(7);
            }
            this.workManager = tp.createWorkManager(connector.getName() + "." + endpoint.getName() + ".receiver");
            try {
                this.workManager.start();
            }
            catch (UMOException e) {
                throw new InitialisationException(e, (Object)this);
            }
        }
        this.connectionStrategy = this.connector.getConnectionStrategy();
    }

    public UMOEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void handleException(Exception exception) {
        if (exception instanceof ConnectException) {
            this.logger.info((Object)"Exception caught is a ConnectException, disconnecting receiver and invoking ReconnectStrategy");
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.connector.getExceptionListener().exceptionThrown(e);
                this.setExceptionCode(exception);
                return;
            }
        }
        this.connector.getExceptionListener().exceptionThrown(exception);
        this.setExceptionCode(exception);
        if (exception instanceof ConnectException) {
            try {
                this.connectionStrategy.connect(this);
            }
            catch (UMOException e) {
                this.connector.getExceptionListener().exceptionThrown(e);
                this.setExceptionCode(exception);
            }
        }
    }

    public void setExceptionCode(Exception exception) {
        String propName = ExceptionHelper.getErrorCodePropertyName(this.connector.getProtocol());
        UMOMessage message = RequestContext.getEvent().getMessage();
        if (propName != null && message != null) {
            String code = ExceptionHelper.getErrorMapping(this.connector.getProtocol(), exception.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting error code for: " + this.connector.getProtocol() + ", " + propName + "=" + code));
            }
            message.setProperty(propName, code);
        }
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void setConnector(UMOConnector connector) {
        if (connector != null) {
            if (!(connector instanceof AbstractConnector)) {
                throw new IllegalArgumentException(new Message(157, "connector", (Object)(class$org$mule$providers$AbstractConnector == null ? (class$org$mule$providers$AbstractConnector = AbstractMessageReceiver.class$("org.mule.providers.AbstractConnector")) : class$org$mule$providers$AbstractConnector).getName(), (Object)connector.getClass().getName()).getMessage());
            }
        } else {
            throw new NullPointerException(new Message(45, "connector").getMessage());
        }
        this.connector = (AbstractConnector)connector;
    }

    public UMOComponent getComponent() {
        return this.component;
    }

    public final UMOMessage routeMessage(UMOMessage message) throws UMOException {
        return this.routeMessage(message, this.endpoint.isSynchronous() || TransactionCoordination.getInstance().getTransaction() != null);
    }

    public final UMOMessage routeMessage(UMOMessage message, boolean synchronous) throws UMOException {
        UMOTransaction tx;
        return this.routeMessage(message, tx, (tx = TransactionCoordination.getInstance().getTransaction()) != null || synchronous, null);
    }

    public final UMOMessage routeMessage(UMOMessage message, UMOTransaction trans, boolean synchronous) throws UMOException {
        return this.routeMessage(message, trans, synchronous, null);
    }

    public final UMOMessage routeMessage(UMOMessage message, OutputStream outputStream) throws UMOException {
        return this.routeMessage(message, this.endpoint.isSynchronous(), outputStream);
    }

    public final UMOMessage routeMessage(UMOMessage message, boolean synchronous, OutputStream outputStream) throws UMOException {
        UMOTransaction tx;
        return this.routeMessage(message, tx, (tx = TransactionCoordination.getInstance().getTransaction()) != null || synchronous, outputStream);
    }

    public final UMOMessage routeMessage(UMOMessage message, UMOTransaction trans, boolean synchronous, OutputStream outputStream) throws UMOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message Received from: " + this.endpoint.getEndpointURI()));
            this.logger.debug((Object)message);
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Message Payload: \n" + message.getPayloadAsString()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ResponseOutputStream ros = null;
        if (outputStream != null) {
            ros = outputStream instanceof ResponseOutputStream ? (ResponseOutputStream)outputStream : new ResponseOutputStream(outputStream);
        }
        if (this.endpoint.getFilter() != null && !this.endpoint.getFilter().accept(message)) {
            this.handleUnacceptedFilter(message);
            return null;
        }
        MuleSession session = new MuleSession(this.component, trans);
        UMOEvent muleEvent = new MuleEvent(message, this.endpoint, (UMOSession)session, synchronous, ros);
        RequestContext.setEvent(muleEvent);
        if (this.endpoint.getSecurityFilter() != null) {
            try {
                this.endpoint.getSecurityFilter().authenticate(muleEvent);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireEvent(new SecurityEvent(e, 401));
                this.handleException(e);
                return message;
            }
        }
        muleEvent = RequestContext.getEvent();
        UMOMessage resultMessage = null;
        if ("response".equals(this.endpoint.getType())) {
            this.component.getDescriptor().getResponseRouter().route(muleEvent);
            return null;
        }
        resultMessage = this.component.getDescriptor().getInboundRouter().route(muleEvent);
        return resultMessage;
    }

    protected UMOMessage handleUnacceptedFilter(UMOMessage message) {
        String messageId = null;
        try {
            messageId = message.getUniqueId();
        }
        catch (UniqueIdNotSupportedException e) {
            messageId = "'no unique id'";
        }
        this.logger.warn((Object)("Message " + messageId + " failed to pass filter on endpoint: " + this.endpoint + ". Message is being ignored"));
        return null;
    }

    public void setEndpoint(UMOEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        this.endpoint = endpoint;
    }

    public void setComponent(UMOComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        this.component = component;
    }

    public final void dispose() {
        this.stop();
        this.disposing.set(true);
        this.doDispose();
        this.workManager.dispose();
    }

    protected void doDispose() {
    }

    public UMOEndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    protected UMOWorkManager getWorkManager() {
        return this.workManager;
    }

    protected void setWorkManager(UMOWorkManager workManager) {
        this.workManager = workManager;
    }

    public void connect() throws Exception {
        if (this.connected.get()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to connect to: " + this.endpoint.getEndpointURI()));
        }
        if (!this.connecting) {
            this.connecting = true;
            this.connectionStrategy.connect(this);
            this.logger.info((Object)("Successfully connected to: " + this.endpoint.getEndpointURI()));
            return;
        }
        try {
            this.doConnect();
            this.connector.fireEvent(new ConnectionEvent(this.endpoint.getEndpointURI(), 701));
        }
        catch (Exception e) {
            this.connector.fireEvent(new ConnectionEvent(this.endpoint.getEndpointURI(), 702));
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            throw new ConnectException(e, (Object)this);
        }
        this.connected.set(true);
        this.connecting = false;
    }

    public void disconnect() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting from: " + this.endpoint.getEndpointURI()));
        }
        this.doDisconnect();
        this.logger.info((Object)("Disconnected from: " + this.endpoint.getEndpointURI()));
        this.connector.fireEvent(new ConnectionEvent(this.endpoint.getEndpointURI(), 703));
        this.connected.set(false);
    }

    public final void start() throws UMOException {
        if (this.stopped.get()) {
            this.stopped.set(false);
            if (!this.connected.get()) {
                this.connectionStrategy.connect(this);
            }
            this.doStart();
        }
    }

    public final void stop() {
        if (!this.stopped.get()) {
            this.stopped.set(true);
            try {
                this.doStop();
            }
            catch (UMOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public abstract void doConnect() throws Exception;

    public abstract void doDisconnect() throws Exception;

    public void doStart() throws UMOException {
    }

    public void doStop() throws UMOException {
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

