/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.FatalConnectException;

public class SimpleRetryConnectionStrategy
implements ConnectionStrategy {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private int retryCount = 2;
    private long frequency = 2000L;
    private int count = 0;

    public void connect(AbstractMessageReceiver receiver) throws FatalConnectException {
        while (true) {
            try {
                ++this.count;
                receiver.connect();
                this.count = 0;
                this.logger.debug((Object)("Successfully connected to " + receiver.getEndpoint().getEndpointURI()));
            }
            catch (Exception e) {
                if (this.count == this.retryCount) {
                    throw new FatalConnectException(new Message(164, this.getClass().getName(), (Object)receiver.getEndpoint().getEndpointURI()), e, receiver);
                }
                this.logger.warn((Object)("Failed to connect/reconnect on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                this.logger.debug((Object)("Waiting for " + this.frequency + "ms before reconnecting"));
                try {
                    Thread.sleep(this.frequency);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }
}

