/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import EDU.oswego.cs.dl.util.concurrent.CountDown;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.Iterator;
import java.util.List;
import javax.resource.spi.work.Work;
import org.mule.config.ThreadingProfile;
import org.mule.providers.PollingMessageReceiver;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionTemplate;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public abstract class TransactedPollingMessageReceiver
extends PollingMessageReceiver {
    protected boolean receiveMessagesInTransaction = true;

    public TransactedPollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Long frequency) throws InitialisationException {
        super(connector, component, endpoint, frequency);
    }

    public void doStart() throws UMOException {
        super.doStart();
        ThreadingProfile tp = this.connector.getReceiverThreadingProfile();
        if (this.receiveMessagesInTransaction && tp.isDoThreading()) {
            for (int i = 0; i < tp.getMaxThreadsActive(); ++i) {
                super.start();
            }
        } else {
            super.start();
        }
    }

    public void poll() throws Exception {
        TransactionTemplate tt = new TransactionTemplate(this.endpoint.getTransactionConfig(), this.connector.getExceptionListener());
        if (this.receiveMessagesInTransaction) {
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    List messages = TransactedPollingMessageReceiver.this.getMessages();
                    if (messages != null && messages.size() > 0) {
                        Iterator it = messages.iterator();
                        while (it.hasNext()) {
                            Object message = it.next();
                            if (TransactedPollingMessageReceiver.this.logger.isTraceEnabled()) {
                                TransactedPollingMessageReceiver.this.logger.trace((Object)("Received Message: " + message));
                            }
                            TransactedPollingMessageReceiver.this.processMessage(message);
                        }
                    }
                    return null;
                }
            };
            tt.execute(cb);
        } else {
            List messages = this.getMessages();
            if (messages != null && messages.size() > 0) {
                CountDown countdown = new CountDown(messages.size());
                Iterator it = messages.iterator();
                while (it.hasNext()) {
                    Object message = it.next();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Received Message: " + message));
                    }
                    try {
                        this.getWorkManager().scheduleWork(new MessageProcessorWorker(tt, (Sync)countdown, message));
                    }
                    catch (Exception e) {
                        countdown.release();
                        throw e;
                    }
                }
                countdown.acquire();
            }
        }
    }

    protected abstract List getMessages() throws Exception;

    protected abstract void processMessage(Object var1) throws Exception;

    protected class MessageProcessorWorker
    implements Work,
    TransactionCallback {
        private TransactionTemplate tt;
        private Object message;
        private Sync sync;

        public MessageProcessorWorker(TransactionTemplate tt, Sync sync, Object message) {
            this.tt = tt;
            this.message = message;
        }

        public void release() {
        }

        public void run() {
            try {
                this.tt.execute(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Object doInTransaction() throws Exception {
            TransactedPollingMessageReceiver.this.processMessage(this.message);
            return null;
        }
    }
}

