/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Map;
import org.mule.impl.MuleEvent;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.RoutingException;

public abstract class AbstractEventAggregator
extends SelectiveConsumer {
    protected static final String NO_CORRELATION_ID = "no-id";
    protected Map eventGroups = new ConcurrentHashMap();
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        SynchronizedBoolean doAggregate = new SynchronizedBoolean(false);
        EventGroup eg = null;
        if (this.isMatch(event)) {
            eg = this.addEvent(event);
            doAggregate.commit(false, this.shouldAggregate(eg));
        }
        if (doAggregate.get()) {
            Object object = this.lock;
            synchronized (object) {
                UMOMessage returnMessage = this.aggregateEvents(eg);
                this.removeGroup(eg.getGroupId());
                MuleEndpoint endpoint = new MuleEndpoint(event.getEndpoint());
                endpoint.setTransformer(null);
                endpoint.setName(this.getClass().getName());
                MuleEvent returnEvent = new MuleEvent(returnMessage, (UMOEndpoint)endpoint, event.getComponent(), event);
                return new UMOEvent[]{returnEvent};
            }
        }
        return null;
    }

    protected EventGroup addEvent(UMOEvent event) {
        EventGroup eg;
        String cId = event.getMessage().getCorrelationId();
        if (cId == null) {
            cId = NO_CORRELATION_ID;
        }
        if ((eg = (EventGroup)this.eventGroups.get(cId)) == null) {
            eg = new EventGroup(cId);
            eg.addEvent(event);
            this.eventGroups.put(eg.getGroupId(), eg);
        } else {
            eg.addEvent(event);
        }
        return eg;
    }

    protected void removeGroup(String id) {
        this.eventGroups.remove(id);
    }

    protected abstract boolean shouldAggregate(EventGroup var1);

    protected abstract UMOMessage aggregateEvents(EventGroup var1) throws RoutingException;
}

