/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.mule.impl.MuleEvent;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOOutboundMessageRouter;

public class ForwardingConsumer
extends SelectiveConsumer {
    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        if (super.process(event) != null) {
            UMOOutboundMessageRouter router = event.getComponent().getDescriptor().getOutboundRouter();
            event.setStopFurtherProcessing(true);
            if (router == null) {
                this.logger.debug((Object)"Descriptor has no outbound router configured to forward to, continuing with normal processing");
                return new UMOEvent[]{event};
            }
            try {
                UMOMessage msg = router.route(event.getMessage(), event.getSession(), event.isSynchronous());
                if (msg != null) {
                    return new UMOEvent[]{new MuleEvent(msg, event)};
                }
                return null;
            }
            catch (UMOException e) {
                throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        return null;
    }
}

