/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.routing.AbstractRouterCollection;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionTemplate;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOOutboundMessageRouter;
import org.mule.umo.routing.UMOOutboundRouter;

public class OutboundMessageRouter
extends AbstractRouterCollection
implements UMOOutboundMessageRouter {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$routing$outbound$OutboundMessageRouter == null ? (class$org$mule$routing$outbound$OutboundMessageRouter = OutboundMessageRouter.class$("org.mule.routing.outbound.OutboundMessageRouter")) : class$org$mule$routing$outbound$OutboundMessageRouter));
    static /* synthetic */ Class class$org$mule$routing$outbound$OutboundMessageRouter;

    public OutboundMessageRouter() {
        super(2);
    }

    public UMOMessage route(final UMOMessage message, final UMOSession session, final boolean synchronous) throws MessagingException {
        UMOMessage result = null;
        boolean matchfound = false;
        Iterator iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            UMOOutboundRouter umoOutboundRouter = (UMOOutboundRouter)iterator.next();
            if (!umoOutboundRouter.isMatch(message)) continue;
            matchfound = true;
            final UMOOutboundRouter router = umoOutboundRouter;
            TransactionTemplate tt = new TransactionTemplate(umoOutboundRouter.getTransactionConfig(), session.getComponent().getDescriptor().getExceptionListener());
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    return router.route(message, session, synchronous);
                }
            };
            try {
                result = (UMOMessage)tt.execute(cb);
            }
            catch (Exception e) {
                throw new RoutingException(message, null, (Throwable)e);
            }
            if (this.isMatchAll()) continue;
            return result;
        }
        if (!matchfound && this.getCatchAllStrategy() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message did not match any routers on: " + session.getComponent().getDescriptor().getName() + " invoking catch all strategy"));
            }
            return this.catchAll(message, session, synchronous);
        }
        if (!matchfound) {
            logger.warn((Object)("Message did not match any routers on: " + session.getComponent().getDescriptor().getName() + " and there is no catch all strategy configured on this router.  Disposing message."));
        }
        return message;
    }

    public UMOEndpoint[] getEndpointsForMessage(UMOMessage message) throws MessagingException {
        ArrayList endpoints = new ArrayList();
        Iterator iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            UMOOutboundRouter umoOutboundRouter = (UMOOutboundRouter)iterator.next();
            if (!umoOutboundRouter.isMatch(message)) continue;
            endpoints.addAll(umoOutboundRouter.getEndpoints());
            if (this.isMatchAll()) continue;
            break;
        }
        UMOEndpoint[] result = new UMOEndpoint[endpoints.size()];
        return endpoints.toArray(result);
    }

    protected UMOMessage catchAll(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        if (this.getStatistics().isEnabled()) {
            this.getStatistics().incrementCaughtMessage();
        }
        return this.getCatchAllStrategy().catchMessage(message, null, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

