/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseRouter;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.ResponseTimeoutException;
import org.mule.umo.routing.RoutingException;

public abstract class AbstractResponseAggregator
extends AbstractResponseRouter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private Map responseEvents = new ConcurrentHashMap();
    private Map locks = new ConcurrentHashMap();
    protected long timeout = 5000L;
    protected Map eventGroups = new ConcurrentHashMap();
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(UMOEvent event) throws RoutingException {
        SynchronizedBoolean doAggregate = new SynchronizedBoolean(false);
        EventGroup eg = this.addEvent(event);
        doAggregate.commit(false, this.shouldAggregate(eg));
        if (doAggregate.get()) {
            Object object = this.lock;
            synchronized (object) {
                UMOMessage returnMessage = this.aggregateEvents(eg);
                String id = eg.getGroupId();
                this.removeGroup(id);
                this.responseEvents.put(id, returnMessage);
                Sync s = (Sync)this.locks.get(id);
                if (s == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Creating latch for " + id + " in " + this));
                    }
                    s = new Latch();
                    this.locks.put(id, s);
                }
                s.release();
            }
        }
    }

    protected EventGroup addEvent(UMOEvent event) throws RoutingException {
        String cId = (String)this.correlationExtractor.getProperty("MULE_CORRELATION_ID", event.getMessage());
        if (cId == null) {
            throw new RoutingException(new Message(66), event.getMessage(), event.getEndpoint());
        }
        EventGroup eg = (EventGroup)this.eventGroups.get(cId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding event to response aggregator group: " + cId));
        }
        if (eg == null) {
            eg = new EventGroup(cId);
            eg.addEvent(event);
            this.eventGroups.put(eg.getGroupId(), eg);
        } else {
            eg.addEvent(event);
        }
        return eg;
    }

    protected void removeGroup(String id) {
        this.eventGroups.remove(id);
    }

    public UMOMessage getResponse(UMOMessage message) throws RoutingException {
        Sync s;
        String messageId = null;
        messageId = message.getUniqueId();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Waiting for response for message id: " + messageId + " in " + this));
        }
        if ((s = (Sync)this.locks.get(messageId)) == null) {
            this.logger.debug((Object)("Got response but no one is waiting for it yet. Creating latch for " + messageId + " in " + this));
            s = new Latch();
            this.locks.put(messageId, s);
        } else {
            this.logger.debug((Object)("Got latch for message: " + messageId));
        }
        boolean b = false;
        try {
            this.logger.debug((Object)("Waiting for response to message: " + messageId));
            if (this.timeout <= 0L) {
                s.acquire();
                b = true;
            } else {
                b = s.attempt(this.timeout);
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!b) {
            throw new ResponseTimeoutException(new Message(90, String.valueOf(this.timeout), (Object)messageId), message, null);
        }
        UMOMessage result = (UMOMessage)this.responseEvents.get(messageId);
        this.locks.remove(messageId);
        if (result == null) {
            throw new IllegalStateException("Response Message is null");
        }
        return result;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected abstract boolean shouldAggregate(EventGroup var1);

    protected abstract UMOMessage aggregateEvents(EventGroup var1) throws RoutingException;
}

