/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.file.DeleteException;
import org.mule.util.file.FileSession;
import org.mule.util.xa.AbstractTransactionContext;
import org.mule.util.xa.AbstractXAResourceManager;
import org.mule.util.xa.ResourceManagerException;

public class FileManager
extends AbstractXAResourceManager {
    private static Log logger = LogFactory.getLog((Class)(class$org$mule$util$file$FileManager == null ? (class$org$mule$util$file$FileManager = FileManager.class$("org.mule.util.file.FileManager")) : class$org$mule$util$file$FileManager));
    static /* synthetic */ Class class$org$mule$util$file$FileManager;

    public synchronized FileSession createSession() {
        return new FileSessionImpl();
    }

    protected Log getLogger() {
        return logger;
    }

    protected AbstractTransactionContext createTransactionContext(Object session) {
        return new FileTransactionContext();
    }

    protected void doBegin(AbstractTransactionContext context) {
    }

    protected int doPrepare(AbstractTransactionContext context) {
        return 0;
    }

    protected void doCommit(AbstractTransactionContext context) throws ResourceManagerException {
    }

    protected void doRollback(AbstractTransactionContext context) throws ResourceManagerException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class FileTransactionContext
    extends AbstractTransactionContext {
        protected FileTransactionContext() {
        }
    }

    protected class FileSessionImpl
    extends AbstractXAResourceManager.AbstractSession
    implements FileSession {
        protected FileSessionImpl() {
            super(FileManager.this);
        }

        public FileInputStream openInputStream(File f) throws IOException {
            if (this.localContext != null) {
                return null;
            }
            return new FileInputStream(f);
        }

        public FileOutputStream openOutputStream(File f, boolean append) throws IOException {
            if (this.localContext != null) {
                return null;
            }
            return new FileOutputStream(f, append);
        }

        public FileOutputStream openOutputStream(File f) throws IOException {
            return this.openOutputStream(f, false);
        }

        public boolean mkdir(File f) throws IOException {
            if (this.localContext != null) {
                return false;
            }
            return f.mkdir();
        }

        public RandomAccessFile openRandomAccess(File f, String mode) throws IOException {
            if (this.localContext != null) {
                return null;
            }
            return new RandomAccessFile(f, mode);
        }

        public void delete(File f) throws IOException {
            if (this.localContext == null && !f.delete()) {
                throw new DeleteException(f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy(File source, File dest) throws IOException {
            if (dest.exists()) {
                this.delete(dest);
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                is = this.openInputStream(source);
                try {
                    os = this.openOutputStream(dest);
                    byte[] buffer = new byte[4096];
                    int n = 0;
                    while (-1 != (n = ((InputStream)is).read(buffer))) {
                        ((OutputStream)os).write(buffer, 0, n);
                    }
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }

        public void rename(File source, File dest) throws IOException {
            this.copy(source, dest);
            this.delete(dest);
        }
    }
}

