/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.transaction.TransactionManager;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.MuleServer;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleConfiguration;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleModel;
import org.mule.impl.container.MultiContainerContext;
import org.mule.impl.internal.admin.MuleAdminAgent;
import org.mule.impl.internal.events.ManagerEvent;
import org.mule.impl.internal.events.ServerEventManager;
import org.mule.impl.security.MuleSecurityManager;
import org.mule.impl.work.MuleWorkManager;
import org.mule.management.stats.AllStatistics;
import org.mule.umo.UMOException;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOServerEvent;
import org.mule.umo.manager.UMOServerEventListener;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.PropertiesHelper;
import org.mule.util.SpiHelper;
import org.mule.util.StringMessageHelper;
import org.mule.util.Utility;
import org.mule.util.queue.CachingPersistenceStrategy;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.TransactionalQueueManager;

public class MuleManager
implements UMOManager {
    private static UMOManager instance = null;
    private static MuleConfiguration config = new MuleConfiguration();
    private Map connectors = new HashMap();
    private Map endpointIdentifiers = new HashMap();
    private Map applicationProps = new HashMap();
    private Map agents = new SequencedHashMap();
    private Map endpoints = new HashMap();
    private UMOModel model;
    private String id = null;
    private TransactionManager transactionManager = null;
    private HashMap transformers = new HashMap();
    private SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    private SynchronizedBoolean initialising = new SynchronizedBoolean(false);
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private SynchronizedBoolean starting = new SynchronizedBoolean(false);
    private SynchronizedBoolean disposed = new SynchronizedBoolean(false);
    private static MuleServer server = null;
    private HashMap interceptorsMap = new HashMap();
    private long startDate = 0L;
    private AllStatistics stats = new AllStatistics();
    private ServerEventManager eventManager = null;
    private MultiContainerContext containerContext = null;
    private UMOSecurityManager securityManager;
    private QueueManager queueManager;
    private UMOWorkManager workManager;
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$MuleManager == null ? (class$org$mule$MuleManager = MuleManager.class$("org.mule.MuleManager")) : class$org$mule$MuleManager));
    static /* synthetic */ Class class$org$mule$MuleManager;
    static /* synthetic */ Class class$org$mule$umo$manager$UMOManager;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ManagerEvent;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ManagerEventListener;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ModelEvent;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ModelEventListener;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ComponentEvent;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ComponentEventListener;
    static /* synthetic */ Class class$org$mule$impl$internal$events$SecurityEvent;
    static /* synthetic */ Class class$org$mule$impl$internal$events$SecurityEventListener;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ManagementEvent;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ManagementEventListener;
    static /* synthetic */ Class class$org$mule$impl$internal$events$AdminEvent;
    static /* synthetic */ Class class$org$mule$impl$internal$events$AdminEventListener;
    static /* synthetic */ Class class$org$mule$impl$internal$events$CustomEvent;
    static /* synthetic */ Class class$org$mule$impl$internal$events$CustomEventListener;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ConnectionEvent;
    static /* synthetic */ Class class$org$mule$impl$internal$events$ConnectionEventListener;

    private MuleManager() {
        if (config == null) {
            config = new MuleConfiguration();
        }
        this.setModel(new MuleModel());
        this.containerContext = new MultiContainerContext();
        this.securityManager = new MuleSecurityManager();
    }

    protected static synchronized UMOManager createInstance() {
        Class clazz = SpiHelper.findService(class$org$mule$umo$manager$UMOManager == null ? (class$org$mule$umo$manager$UMOManager = MuleManager.class$("org.mule.umo.manager.UMOManager")) : class$org$mule$umo$manager$UMOManager, (class$org$mule$MuleManager == null ? (class$org$mule$MuleManager = MuleManager.class$("org.mule.MuleManager")) : class$org$mule$MuleManager).getName(), class$org$mule$MuleManager == null ? (class$org$mule$MuleManager = MuleManager.class$("org.mule.MuleManager")) : class$org$mule$MuleManager);
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(new Message(144, clazz.getName()), (Throwable)e);
        }
        MuleManager.setInstance(obj);
        return MuleManager.getInstance();
    }

    public static UMOManager getInstance() {
        if (instance == null) {
            instance = MuleManager.createInstance();
        }
        return instance;
    }

    public static boolean isInstanciated() {
        return instance != null;
    }

    public static synchronized void setInstance(UMOManager manager) {
        instance = manager;
        if (instance == null) {
            config = new MuleConfiguration();
        }
    }

    public AllStatistics getStatistics() {
        return this.stats;
    }

    public void setStatistics(AllStatistics stat) {
        this.stats = stat;
    }

    public static MuleConfiguration getConfiguration() {
        return config;
    }

    public static void setConfiguration(MuleConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException(new Message(45, "MuleConfiguration object").getMessage());
        }
        MuleManager.config = config;
    }

    public synchronized void dispose() {
        if (this.disposed.get()) {
            return;
        }
        try {
            if (this.started.get()) {
                this.stop();
            }
        }
        catch (UMOException e) {
            logger.error((Object)("Failed to stop manager: " + e.getMessage()), (Throwable)e);
        }
        this.disposed.set(true);
        this.disposeConnectors();
        this.model.dispose();
        this.disposeAgents();
        this.transformers.clear();
        this.endpoints.clear();
        this.endpointIdentifiers.clear();
        this.containerContext.dispose();
        this.fireSystemEvent(new ManagerEvent(this, 108));
        this.transformers = null;
        this.endpoints = null;
        this.endpointIdentifiers = null;
        this.initialised.set(false);
        if (this.eventManager != null) {
            this.eventManager.dispose();
        }
        if (this.workManager != null) {
            this.workManager.dispose();
        }
        config = null;
        config = new MuleConfiguration();
        instance = null;
        if (!config.isEmbedded()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\n" + this.getEndSplash()));
            } else {
                System.out.println(this.getEndSplash());
            }
        }
    }

    private synchronized void disposeConnectors() {
        this.fireSystemEvent(new ManagerEvent(this, 109));
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.dispose();
        }
        this.fireSystemEvent(new ManagerEvent(this, 110));
    }

    public Object getProperty(Object key) {
        return this.applicationProps.get(key);
    }

    public Map getProperties() {
        return this.applicationProps;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public UMOConnector lookupConnector(String name) {
        return (UMOConnector)this.connectors.get(name);
    }

    public String lookupEndpointIdentifier(String logicalName, String defaultName) {
        String name = (String)this.endpointIdentifiers.get(logicalName);
        if (name == null) {
            return defaultName;
        }
        return name;
    }

    public UMOEndpoint lookupEndpoint(String logicalName) {
        UMOEndpoint endpoint = (UMOEndpoint)this.endpoints.get(logicalName);
        if (endpoint != null) {
            return (UMOEndpoint)endpoint.clone();
        }
        return null;
    }

    public UMOTransformer lookupTransformer(String name) {
        UMOTransformer trans = (UMOTransformer)this.transformers.get(name);
        if (trans != null) {
            try {
                return (UMOTransformer)trans.clone();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(new Message(145, "Transformer: " + trans.getName()), (Throwable)e);
            }
        }
        return null;
    }

    public void registerConnector(UMOConnector connector) throws UMOException {
        this.connectors.put(connector.getName(), connector);
        if (this.initialised.get() || this.initialising.get()) {
            connector.initialise();
        }
        if ((this.started.get() || this.starting.get()) && !connector.isStarted()) {
            connector.startConnector();
        }
    }

    public void unregisterConnector(String connectorName) throws UMOException {
        UMOConnector c = (UMOConnector)this.connectors.remove(connectorName);
        if (c != null) {
            c.dispose();
        }
    }

    public void registerEndpointIdentifier(String logicalName, String endpoint) {
        this.endpointIdentifiers.put(logicalName, endpoint);
    }

    public void unregisterEndpointIdentifier(String logicalName) {
        this.endpointIdentifiers.remove(logicalName);
    }

    public void registerEndpoint(UMOEndpoint endpoint) {
        this.endpoints.put(endpoint.getName(), endpoint);
    }

    public void unregisterEndpoint(String endpointName) {
        UMOEndpoint p = (UMOEndpoint)this.endpoints.get(endpointName);
        if (p != null) {
            this.endpoints.remove(p);
        }
    }

    public void registerTransformer(UMOTransformer transformer) throws InitialisationException {
        transformer.initialise();
        this.transformers.put(transformer.getName(), transformer);
        logger.info((Object)("Transformer" + transformer.getName() + " has been initialised successfully"));
    }

    public void unregisterTransformer(String transformerName) {
        this.transformers.remove(transformerName);
    }

    public void setProperty(Object key, Object value) {
        this.applicationProps.put(key, value);
    }

    public void addProperties(Map props) {
        this.applicationProps.putAll(props);
    }

    public void setTransactionManager(TransactionManager newManager) throws UMOException {
        if (this.transactionManager != null) {
            throw new ConfigurationException(new Message(140));
        }
        this.transactionManager = newManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialise() throws UMOException {
        if (!this.initialised.get()) {
            this.initialising.set(true);
            if (this.workManager == null) {
                ThreadingProfile tp = config.getDefaultThreadingProfile();
                logger.debug((Object)("Creating default work manager using default threading profile: " + tp));
                this.workManager = new MuleWorkManager(tp, "UMOManager");
                this.workManager.start();
            }
            this.eventManager = new ServerEventManager(this.workManager);
            this.eventManager.registerEventType(class$org$mule$impl$internal$events$ManagerEvent == null ? (class$org$mule$impl$internal$events$ManagerEvent = MuleManager.class$("org.mule.impl.internal.events.ManagerEvent")) : class$org$mule$impl$internal$events$ManagerEvent, class$org$mule$impl$internal$events$ManagerEventListener == null ? (class$org$mule$impl$internal$events$ManagerEventListener = MuleManager.class$("org.mule.impl.internal.events.ManagerEventListener")) : class$org$mule$impl$internal$events$ManagerEventListener);
            this.eventManager.registerEventType(class$org$mule$impl$internal$events$ModelEvent == null ? (class$org$mule$impl$internal$events$ModelEvent = MuleManager.class$("org.mule.impl.internal.events.ModelEvent")) : class$org$mule$impl$internal$events$ModelEvent, class$org$mule$impl$internal$events$ModelEventListener == null ? (class$org$mule$impl$internal$events$ModelEventListener = MuleManager.class$("org.mule.impl.internal.events.ModelEventListener")) : class$org$mule$impl$internal$events$ModelEventListener);
            this.eventManager.registerEventType(class$org$mule$impl$internal$events$ComponentEvent == null ? (class$org$mule$impl$internal$events$ComponentEvent = MuleManager.class$("org.mule.impl.internal.events.ComponentEvent")) : class$org$mule$impl$internal$events$ComponentEvent, class$org$mule$impl$internal$events$ComponentEventListener == null ? (class$org$mule$impl$internal$events$ComponentEventListener = MuleManager.class$("org.mule.impl.internal.events.ComponentEventListener")) : class$org$mule$impl$internal$events$ComponentEventListener);
            this.eventManager.registerEventType(class$org$mule$impl$internal$events$SecurityEvent == null ? (class$org$mule$impl$internal$events$SecurityEvent = MuleManager.class$("org.mule.impl.internal.events.SecurityEvent")) : class$org$mule$impl$internal$events$SecurityEvent, class$org$mule$impl$internal$events$SecurityEventListener == null ? (class$org$mule$impl$internal$events$SecurityEventListener = MuleManager.class$("org.mule.impl.internal.events.SecurityEventListener")) : class$org$mule$impl$internal$events$SecurityEventListener);
            this.eventManager.registerEventType(class$org$mule$impl$internal$events$ManagementEvent == null ? (class$org$mule$impl$internal$events$ManagementEvent = MuleManager.class$("org.mule.impl.internal.events.ManagementEvent")) : class$org$mule$impl$internal$events$ManagementEvent, class$org$mule$impl$internal$events$ManagementEventListener == null ? (class$org$mule$impl$internal$events$ManagementEventListener = MuleManager.class$("org.mule.impl.internal.events.ManagementEventListener")) : class$org$mule$impl$internal$events$ManagementEventListener);
            this.eventManager.registerEventType(class$org$mule$impl$internal$events$AdminEvent == null ? (class$org$mule$impl$internal$events$AdminEvent = MuleManager.class$("org.mule.impl.internal.events.AdminEvent")) : class$org$mule$impl$internal$events$AdminEvent, class$org$mule$impl$internal$events$AdminEventListener == null ? (class$org$mule$impl$internal$events$AdminEventListener = MuleManager.class$("org.mule.impl.internal.events.AdminEventListener")) : class$org$mule$impl$internal$events$AdminEventListener);
            this.eventManager.registerEventType(class$org$mule$impl$internal$events$CustomEvent == null ? (class$org$mule$impl$internal$events$CustomEvent = MuleManager.class$("org.mule.impl.internal.events.CustomEvent")) : class$org$mule$impl$internal$events$CustomEvent, class$org$mule$impl$internal$events$CustomEventListener == null ? (class$org$mule$impl$internal$events$CustomEventListener = MuleManager.class$("org.mule.impl.internal.events.CustomEventListener")) : class$org$mule$impl$internal$events$CustomEventListener);
            this.eventManager.registerEventType(class$org$mule$impl$internal$events$ConnectionEvent == null ? (class$org$mule$impl$internal$events$ConnectionEvent = MuleManager.class$("org.mule.impl.internal.events.ConnectionEvent")) : class$org$mule$impl$internal$events$ConnectionEvent, class$org$mule$impl$internal$events$ConnectionEventListener == null ? (class$org$mule$impl$internal$events$ConnectionEventListener = MuleManager.class$("org.mule.impl.internal.events.ConnectionEventListener")) : class$org$mule$impl$internal$events$ConnectionEventListener);
            this.fireSystemEvent(new ManagerEvent(this, 101));
            if (this.id == null) {
                logger.warn((Object)"No unique id has been set on this manager");
            }
            try {
                if (this.securityManager != null) {
                    this.securityManager.initialise();
                }
                if (this.queueManager == null) {
                    try {
                        TransactionalQueueManager queueMgr = new TransactionalQueueManager();
                        CachingPersistenceStrategy ps = new CachingPersistenceStrategy(MuleManager.getConfiguration().getPersistenceStrategy());
                        queueMgr.setPersistenceStrategy(ps);
                        this.queueManager = queueMgr;
                    }
                    catch (Exception e) {
                        throw new InitialisationException(new Message(85, "QueueManager"), (Object)e);
                    }
                }
                boolean disable = PropertiesHelper.getBooleanProperty(System.getProperties(), "org.mule.disable.server.connections", false);
                if (config.getServerUrl() == null || "".equals(config.getServerUrl().trim())) {
                    logger.info((Object)"Server endpointUri is null, not registering Mule Admin agent");
                    disable = true;
                }
                if (!disable) {
                    this.registerAgent(new MuleAdminAgent());
                }
                this.initialiseConnectors();
                this.initialiseEndpoints();
                this.initialiseAgents();
                this.model.initialise();
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.initialised.set(true);
                this.initialising.set(false);
                this.fireSystemEvent(new ManagerEvent(this, 102));
                throw throwable;
            }
            this.initialised.set(true);
            this.initialising.set(false);
            this.fireSystemEvent(new ManagerEvent(this, 102));
            {
            }
        }
    }

    protected void initialiseEndpoints() throws InitialisationException {
        Iterator iterator = this.endpoints.values().iterator();
        while (iterator.hasNext()) {
            UMOEndpoint ep = (UMOEndpoint)iterator.next();
            ep.initialise();
            ep.setCreateConnector(0);
        }
    }

    public synchronized void start() throws UMOException {
        this.initialise();
        if (!this.started.get()) {
            this.startDate = System.currentTimeMillis();
            this.starting.set(true);
            this.fireSystemEvent(new ManagerEvent(this, 103));
            this.queueManager.start();
            this.startConnectors();
            this.startAgents();
            this.model.start();
            this.started.set(true);
            this.starting.set(false);
            if (!config.isEmbedded()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("\n" + this.getStartSplash()));
                } else {
                    System.out.println(this.getStartSplash());
                }
            }
            this.fireSystemEvent(new ManagerEvent(this, 104));
        }
    }

    public void start(String serverUrl) throws UMOException {
        config.setServerUrl(serverUrl);
        this.start();
    }

    private void startConnectors() throws UMOException {
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.startConnector();
        }
        logger.info((Object)"Connectors have been started successfully");
    }

    private void initialiseConnectors() throws InitialisationException {
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.initialise();
        }
        logger.info((Object)"Connectors have been initialised successfully");
    }

    public synchronized void stop() throws UMOException {
        this.started.set(false);
        this.fireSystemEvent(new ManagerEvent(this, 105));
        logger.debug((Object)"Stopping connectors...");
        this.stopConnectors();
        this.stopAgents();
        this.queueManager.stop();
        logger.debug((Object)"Stopping model...");
        this.model.stop();
        this.fireSystemEvent(new ManagerEvent(this, 106));
    }

    private void stopConnectors() throws UMOException {
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.stopConnector();
        }
        logger.info((Object)"Connectors have been stopped successfully");
    }

    void setServer(MuleServer server) {
        MuleManager.server = server;
    }

    public void shutdown(Throwable e, boolean aggressive) {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(e, aggressive));
        System.exit(0);
    }

    public UMOModel getModel() {
        return this.model;
    }

    public void setModel(UMOModel model) {
        this.model = model;
        if (model instanceof MuleModel) {
            ((MuleModel)model).setListeners(this.eventManager);
        }
    }

    public void registerInterceptorStack(String name, UMOInterceptorStack stack) {
        this.interceptorsMap.put(name, stack);
    }

    public UMOInterceptorStack lookupInterceptorStack(String name) {
        return (UMOInterceptorStack)this.interceptorsMap.get(name);
    }

    public Map getConnectors() {
        return Collections.unmodifiableMap(this.connectors);
    }

    public Map getEndpointIdentifiers() {
        return Collections.unmodifiableMap(this.endpointIdentifiers);
    }

    public Map getEndpoints() {
        return Collections.unmodifiableMap(this.endpoints);
    }

    public Map getTransformers() {
        return Collections.unmodifiableMap(this.transformers);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    public boolean isInitialising() {
        return this.initialising.get();
    }

    public long getStartDate() {
        return this.startDate;
    }

    protected String getStartSplash() {
        String notset = new Message(5).getMessage();
        ArrayList<String> message = new ArrayList<String>();
        Manifest mf = config.getManifest();
        Attributes att = mf.getMainAttributes();
        if (att.values().size() > 0) {
            message.add(PropertiesHelper.getStringProperty(att, new Attributes.Name("Specification-Title"), notset) + " " + new Message(6).getMessage() + " " + PropertiesHelper.getStringProperty(att, new Attributes.Name("Implementation-Version"), notset));
            message.add(PropertiesHelper.getStringProperty(att, new Attributes.Name("Specification-Vendor"), notset));
            message.add(PropertiesHelper.getStringProperty(att, new Attributes.Name("Implementation-Vendor"), notset));
        } else {
            message.add(new Message(1).getMessage());
        }
        message.add(" ");
        message.add(new Message(2, new Date(this.getStartDate()).toString()).getMessage());
        message.add("JDK: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")");
        message.add(" ");
        if (this.agents.size() == 0) {
            message.add(new Message(4).getMessage() + " " + new Message(22).getMessage());
        } else {
            message.add(new Message(4).getMessage());
            Iterator iterator = this.agents.values().iterator();
            while (iterator.hasNext()) {
                UMOAgent umoAgent = (UMOAgent)iterator.next();
                message.add("  " + umoAgent.getDescription());
            }
        }
        return StringMessageHelper.getBoilerPlate(message, '*', 70);
    }

    private String getEndSplash() {
        ArrayList<String> message = new ArrayList<String>(2);
        long currentTime = System.currentTimeMillis();
        message.add(new Message(7, new Date().toString()).getMessage());
        long duration = currentTime;
        if (this.startDate > 0L) {
            duration = currentTime - this.startDate;
        }
        message.add(new Message(8, Utility.getFormattedDuration(duration)).getMessage());
        return StringMessageHelper.getBoilerPlate(message, '*', 80);
    }

    public void registerAgent(UMOAgent agent) throws UMOException {
        this.agents.put(agent.getName(), agent);
        agent.registered();
    }

    public UMOAgent removeAgent(String name) throws UMOException {
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent agent = (UMOAgent)iterator.next();
            if (!agent.getName().equals(name)) continue;
            this.agents.remove(agent);
            agent.dispose();
            agent.unregistered();
            return agent;
        }
        return null;
    }

    protected void initialiseAgents() throws InitialisationException {
        logger.info((Object)"Initialising agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.debug((Object)("Initialising agent: " + umoAgent.getName()));
            umoAgent.initialise();
        }
        logger.info((Object)"Agents Successfully Initialised");
    }

    protected void startAgents() throws UMOException {
        logger.info((Object)"Starting agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.info((Object)("Starting agent: " + umoAgent.getDescription()));
            umoAgent.start();
        }
        logger.info((Object)"Agents Successfully Started");
    }

    protected void stopAgents() throws UMOException {
        logger.info((Object)"Stopping agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.debug((Object)("Stopping agent: " + umoAgent.getName()));
            umoAgent.stop();
        }
        logger.info((Object)"Agents Successfully Stopped");
    }

    protected void disposeAgents() {
        logger.info((Object)"disposing agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.debug((Object)("Disposing agent: " + umoAgent.getName()));
            umoAgent.dispose();
        }
        logger.info((Object)"Agents Successfully Disposed");
    }

    public void setContainerContext(UMOContainerContext container) throws UMOException {
        if (container == null) {
            if (this.containerContext != null) {
                this.containerContext.dispose();
            }
            this.containerContext = new MultiContainerContext();
        } else {
            container.initialise();
            this.containerContext.addContainer(container);
        }
    }

    public UMOContainerContext getContainerContext() {
        return this.containerContext;
    }

    public void registerListener(UMOServerEventListener l) {
        this.registerListener(l, null);
    }

    public void registerListener(UMOServerEventListener l, String resourceIdentifier) {
        if (this.eventManager == null) {
            throw new MuleRuntimeException(new Message(150));
        }
        this.eventManager.registerListener(l, resourceIdentifier);
    }

    public void unregisterListener(UMOServerEventListener l) {
        if (this.eventManager != null) {
            this.eventManager.unregisterListener(l);
        }
    }

    protected void fireSystemEvent(UMOServerEvent e) {
        if (this.eventManager != null) {
            this.eventManager.fireEvent(e);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event Manager is not enabled, ignoring event: " + e));
        }
    }

    public void fireEvent(UMOServerEvent event) {
        if (this.eventManager != null) {
            this.eventManager.fireEvent(event);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event Manager is not enabled, ignoring event: " + event));
        }
    }

    public void setId(String id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setSecurityManager(UMOSecurityManager securityManager) throws InitialisationException {
        this.securityManager = securityManager;
        if (securityManager != null && this.isInitialised()) {
            this.securityManager.initialise();
        }
    }

    public UMOSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public UMOWorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(UMOWorkManager workManager) {
        if (this.workManager != null) {
            throw new IllegalStateException(new Message(165, "workManager").getMessage());
        }
        this.workManager = workManager;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShutdownThread
    extends Thread {
        Throwable t;
        boolean aggressive = true;

        public ShutdownThread(Throwable t, boolean aggressive) {
            this.t = t;
            this.aggressive = aggressive;
        }

        public void run() {
            MuleManager.this.dispose();
            if (!this.aggressive) {
                // empty if block
            }
            if (server != null) {
                if (this.t != null) {
                    server.shutdown(this.t);
                } else {
                    server.shutdown();
                }
            } else {
                ArrayList<String> msgs = new ArrayList<String>();
                if (this.t != null) {
                    msgs.add("Mule is shutting down due to exception: " + this.t.getMessage());
                } else {
                    msgs.add("Mule is shutting down due to normal shutdown request.");
                }
                msgs.add("Shutdown time is: " + new Date().toString());
                StringMessageHelper.getBoilerPlate(msgs, '*', 76);
            }
        }
    }
}

