/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.DefaultComponentExceptionStrategy;
import org.mule.impl.DefaultLifecycleAdapterFactory;
import org.mule.impl.MuleComponentFactory;
import org.mule.impl.MuleSession;
import org.mule.impl.internal.events.ModelEvent;
import org.mule.impl.internal.events.ServerEventManager;
import org.mule.model.DynamicEntryPointResolver;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.UMOLifecycleAdapterFactory;
import org.mule.umo.manager.UMOServerEvent;
import org.mule.umo.model.ModelException;
import org.mule.umo.model.UMOComponentFactory;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.model.UMOModel;

public class MuleModel
implements UMOModel {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$MuleModel == null ? (class$org$mule$impl$MuleModel = MuleModel.class$("org.mule.impl.MuleModel")) : class$org$mule$impl$MuleModel));
    private String name = "mule";
    private UMOEntryPointResolver entryPointResolver;
    private UMOLifecycleAdapterFactory lifecycleAdapterFactory;
    private ConcurrentHashMap components;
    protected ConcurrentHashMap descriptors;
    private SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private ExceptionListener exceptionListener;
    private ServerEventManager listeners;
    private UMOComponentFactory componentFactory;
    static /* synthetic */ Class class$org$mule$impl$MuleModel;

    public MuleModel() {
        this.entryPointResolver = new DynamicEntryPointResolver();
        this.lifecycleAdapterFactory = new DefaultLifecycleAdapterFactory();
        this.components = new ConcurrentHashMap();
        this.descriptors = new ConcurrentHashMap();
        this.exceptionListener = new DefaultComponentExceptionStrategy();
        this.componentFactory = new MuleComponentFactory();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UMOEntryPointResolver getEntryPointResolver() {
        return this.entryPointResolver;
    }

    public void setEntryPointResolver(UMOEntryPointResolver entryPointResolver) {
        this.entryPointResolver = entryPointResolver;
    }

    public boolean isComponentRegistered(String name) {
        return this.components.get((Object)name) != null;
    }

    public UMOComponent registerComponent(UMODescriptor descriptor) throws UMOException {
        if (descriptor == null) {
            throw new ModelException(new Message(45, "UMO Descriptor"));
        }
        if (descriptor.getExceptionListener() == null) {
            descriptor.setExceptionListener(this.exceptionListener);
        }
        if (this.descriptors.get((Object)descriptor.getName()) != null) {
            throw new ModelException(new Message(171, descriptor.getName()));
        }
        UMOComponent component = (UMOComponent)this.components.get((Object)descriptor.getName());
        if (component == null) {
            component = this.componentFactory.create(descriptor);
            this.descriptors.put((Object)descriptor.getName(), (Object)descriptor);
            this.components.put((Object)descriptor.getName(), (Object)component);
        }
        logger.debug((Object)("Added Mule UMO: " + descriptor.getName()));
        if (this.initialised.get()) {
            logger.info((Object)("Initialising component: " + descriptor.getName()));
            component.initialise();
        }
        if (this.started.get()) {
            logger.info((Object)("Starting component: " + descriptor.getName()));
            this.registerListeners(component);
            component.start();
        }
        return component;
    }

    public void unregisterComponent(UMODescriptor descriptor) throws UMOException {
        if (descriptor == null) {
            throw new ModelException(new Message(45, "UMO Descriptor"));
        }
        if (!this.isComponentRegistered(descriptor.getName())) {
            throw new ModelException(new Message(46, descriptor.getName()));
        }
        UMOComponent component = (UMOComponent)this.components.remove((Object)descriptor.getName());
        if (component != null) {
            component.stop();
            this.unregisterListeners(component);
            this.descriptors.remove((Object)descriptor.getName());
            component.dispose();
            logger.info((Object)("The component: " + descriptor.getName() + " has been unregistered and disposing"));
        }
    }

    protected void registerListeners(UMOComponent component) throws UMOException {
        ArrayList<UMOEndpoint> endpoints = new ArrayList<UMOEndpoint>();
        endpoints.addAll(component.getDescriptor().getInboundRouter().getEndpoints());
        if (component.getDescriptor().getInboundEndpoint() != null) {
            endpoints.add(component.getDescriptor().getInboundEndpoint());
        }
        if (component.getDescriptor().getResponseRouter() != null && component.getDescriptor().getResponseRouter().getEndpoints() != null) {
            endpoints.addAll(component.getDescriptor().getResponseRouter().getEndpoints());
        }
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().registerListener(component, endpoint);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(new Message(47, component.getDescriptor().getName(), (Object)endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void unregisterListeners(UMOComponent component) throws UMOException {
        List endpoints = component.getDescriptor().getInboundRouter().getEndpoints();
        if (component.getDescriptor().getInboundEndpoint() != null) {
            endpoints.add(component.getDescriptor().getInboundEndpoint());
        }
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().unregisterListener(component, endpoint);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(new Message(48, component.getDescriptor().getName(), (Object)endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    public UMOLifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    public void setLifecycleAdapterFactory(UMOLifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }

    public void dispose() {
        this.fireEvent(new ModelEvent(this, 209));
        UMOComponent temp = null;
        Object key = null;
        Iterator i = this.components.keySet().iterator();
        while (i.hasNext()) {
            try {
                key = i.next();
                temp = (UMOComponent)this.components.get(key);
                try {
                    temp.dispose();
                }
                catch (Exception e1) {
                    logger.warn((Object)("Failed to dispose component: " + e1.getMessage()));
                }
                logger.info((Object)(temp + " has been destroyed successfully"));
            }
            catch (ConcurrentModificationException e) {
                logger.warn((Object)"cannot dispose calling component");
            }
        }
        this.components.clear();
        this.descriptors.clear();
        this.components = null;
        this.descriptors = null;
        this.fireEvent(new ModelEvent(this, 210));
    }

    public UMOSession getComponentSession(String muleName) {
        UMOComponent component = (UMOComponent)this.components.get((Object)muleName);
        if (component == null) {
            logger.warn((Object)("Component: " + muleName + " not found returning null session"));
            return null;
        }
        return new MuleSession(component, TransactionCoordination.getInstance().getTransaction());
    }

    public void stop() throws UMOException {
        this.fireEvent(new ModelEvent(this, 207));
        Iterator i = this.components.values().iterator();
        while (i.hasNext()) {
            UMOComponent temp = (UMOComponent)i.next();
            temp.stop();
            logger.info((Object)("Component " + temp + " has been stopped successfully"));
        }
        this.fireEvent(new ModelEvent(this, 208));
    }

    public void start() throws UMOException {
        if (!this.initialised.get()) {
            this.initialise();
        }
        if (!this.started.get()) {
            this.fireEvent(new ModelEvent(this, 205));
            Iterator i = this.components.values().iterator();
            while (i.hasNext()) {
                UMOComponent temp = (UMOComponent)i.next();
                this.registerListeners(temp);
                if (temp.getDescriptor().getInitialState().equals("started")) {
                    temp.start();
                    logger.info((Object)("Component " + temp + " has been started successfully"));
                    continue;
                }
                if (temp.getDescriptor().getInitialState().equals("paused")) {
                    temp.start();
                    temp.pause();
                    logger.info((Object)("Component " + temp + " has an initial state of 'paused'"));
                    continue;
                }
                logger.info((Object)("Component " + temp + " has an initial state of 'stopped'"));
            }
            this.started.set(true);
            this.fireEvent(new ModelEvent(this, 206));
        } else {
            logger.debug((Object)"Model already started");
        }
    }

    public void stopComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get((Object)name);
        if (component == null) {
            throw new ModelException(new Message(46, name));
        }
        this.unregisterListeners(component);
        component.stop();
        logger.info((Object)("mule " + name + " has been stopped successfully"));
    }

    public void startComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get((Object)name);
        if (component == null) {
            throw new ModelException(new Message(46, name));
        }
        this.registerListeners(component);
        component.start();
        logger.info((Object)("Mule " + component.toString() + " has been started successfully"));
    }

    public void pauseComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get((Object)name);
        if (component == null) {
            throw new ModelException(new Message(46, name));
        }
        component.pause();
        logger.info((Object)("Mule Component " + name + " has been paused successfully"));
    }

    public void resumeComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get((Object)name);
        if (component == null) {
            throw new ModelException(new Message(46, name));
        }
        component.resume();
        logger.info((Object)("Mule Component " + name + " has been resumed successfully"));
    }

    public void setComponents(List descriptors) throws UMOException {
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            this.registerComponent((UMODescriptor)iterator.next());
        }
    }

    public void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            this.fireEvent(new ModelEvent(this, 201));
            if (this.exceptionListener instanceof Initialisable) {
                ((Initialisable)((Object)this.exceptionListener)).initialise();
            }
            UMOComponent temp = null;
            Iterator i = this.components.values().iterator();
            while (i.hasNext()) {
                temp = (UMOComponent)i.next();
                temp.initialise();
                logger.info((Object)("Component " + temp.getDescriptor().getName() + " has been started successfully"));
            }
            this.initialised.set(true);
            this.fireEvent(new ModelEvent(this, 202));
        } else {
            logger.debug((Object)"Model already initialised");
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public UMODescriptor getDescriptor(String name) {
        return (UMODescriptor)this.descriptors.get((Object)name);
    }

    public Iterator getComponentNames() {
        return this.components.keySet().iterator();
    }

    public void setListeners(ServerEventManager listeners) {
        this.listeners = listeners;
    }

    void fireEvent(UMOServerEvent event) {
        MuleManager.getInstance().fireEvent(event);
    }

    public void setComponentFactory(UMOComponentFactory factory) {
        this.componentFactory = factory;
    }

    public UMOComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

