/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import java.net.URI;
import java.util.Properties;
import org.mule.impl.endpoint.EndpointBuilder;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.util.PropertiesHelper;

public abstract class AbstractEndpointBuilder
implements EndpointBuilder {
    public static final String PROPERTY_ENDPOINT_NAME = "endpointName";
    public static final String PROPERTY_ENDPOINT_URI = "address";
    public static final String PROPERTY_CREATE_CONNECTOR = "createConnector";
    public static final String PROPERTY_CONNECTOR_NAME = "connector";
    public static final String PROPERTY_TRANSFORMERS = "transformers";
    protected String address;
    protected String endpointName;
    protected String connectorName;
    protected String transformers;
    protected String userInfo;
    protected int createConnector = 0;

    public UMOEndpointURI build(URI uri) throws MalformedEndpointException {
        Properties props = this.getPropertiesForURI(uri);
        if (this.address == null) {
            this.setEndpoint(uri, props);
        }
        MuleEndpointURI ep = new MuleEndpointURI(this.address, this.endpointName, this.connectorName, this.transformers, this.createConnector, props, uri, this.userInfo);
        this.address = null;
        this.endpointName = null;
        this.connectorName = null;
        this.transformers = null;
        this.createConnector = 0;
        return ep;
    }

    protected abstract void setEndpoint(URI var1, Properties var2) throws MalformedEndpointException;

    protected Properties getPropertiesForURI(URI uri) {
        String create;
        String cnnName;
        String endpoint;
        Properties properties = PropertiesHelper.getPropertiesFromQueryString(uri.getQuery());
        String tempEndpointName = (String)properties.remove(PROPERTY_ENDPOINT_NAME);
        if (tempEndpointName != null) {
            this.endpointName = tempEndpointName;
        }
        if ((endpoint = (String)properties.remove(PROPERTY_ENDPOINT_URI)) != null) {
            this.address = endpoint;
        }
        if ((cnnName = (String)properties.remove(PROPERTY_CONNECTOR_NAME)) != null) {
            this.connectorName = cnnName;
        }
        if ((create = (String)properties.remove(PROPERTY_CREATE_CONNECTOR)) != null) {
            if ("0".equals(create)) {
                this.createConnector = 0;
            } else if ("1".equals(create)) {
                this.createConnector = 1;
            } else if ("2".equals(create)) {
                this.createConnector = 2;
            } else if ("IF_NEEDED".equals(create)) {
                this.createConnector = 0;
            } else if ("ALWAYS".equals(create)) {
                this.createConnector = 1;
            } else if ("NEVER".equals(create)) {
                this.createConnector = 2;
            } else if (this.connectorName == null) {
                this.createConnector = 3;
                this.connectorName = create;
            }
        }
        this.transformers = (String)properties.remove(PROPERTY_TRANSFORMERS);
        if (this.transformers != null) {
            this.transformers = this.transformers.replaceAll(" ", ",");
        }
        return properties;
    }
}

