/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mule.MuleManager;
import org.mule.impl.internal.events.AdminEventListener;
import org.mule.impl.internal.events.ComponentEventListener;
import org.mule.impl.internal.events.ConnectionEventListener;
import org.mule.impl.internal.events.CustomEventListener;
import org.mule.impl.internal.events.ManagementEventListener;
import org.mule.impl.internal.events.ManagerEventListener;
import org.mule.impl.internal.events.ModelEventListener;
import org.mule.impl.internal.events.SecurityEventListener;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOServerEvent;
import org.mule.umo.manager.UMOServerEventListener;

public abstract class AbstractEventLoggerAgent
implements UMOAgent {
    private String name;
    private boolean ignoreManagerEvents = false;
    private boolean ignoreModelEvents = false;
    private boolean ignoreComponentEvents = false;
    private boolean ignoreConnectionEvents = false;
    private boolean ignoreSecurityEvents = false;
    private boolean ignoreManagementEvents = false;
    private boolean ignoreCustomEvents = false;
    private boolean ignoreAdminEvents = false;
    private Set listeners = new HashSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UMOServerEventListener listener = (UMOServerEventListener)iterator.next();
            MuleManager.getInstance().unregisterListener(listener);
        }
    }

    public boolean isIgnoreManagerEvents() {
        return this.ignoreManagerEvents;
    }

    public void setIgnoreManagerEvents(boolean ignoreManagerEvents) {
        this.ignoreManagerEvents = ignoreManagerEvents;
    }

    public boolean isIgnoreModelEvents() {
        return this.ignoreModelEvents;
    }

    public void setIgnoreModelEvents(boolean ignoreModelEvents) {
        this.ignoreModelEvents = ignoreModelEvents;
    }

    public boolean isIgnoreComponentEvents() {
        return this.ignoreComponentEvents;
    }

    public void setIgnoreComponentEvents(boolean ignoreComponentEvents) {
        this.ignoreComponentEvents = ignoreComponentEvents;
    }

    public boolean isIgnoreSecurityEvents() {
        return this.ignoreSecurityEvents;
    }

    public void setIgnoreSecurityEvents(boolean ignoreSecurityEvents) {
        this.ignoreSecurityEvents = ignoreSecurityEvents;
    }

    public boolean isIgnoreManagementEvents() {
        return this.ignoreManagementEvents;
    }

    public void setIgnoreManagementEvents(boolean ignoreManagementEvents) {
        this.ignoreManagementEvents = ignoreManagementEvents;
    }

    public boolean isIgnoreCustomEvents() {
        return this.ignoreCustomEvents;
    }

    public void setIgnoreCustomEvents(boolean ignoreCustomEvents) {
        this.ignoreCustomEvents = ignoreCustomEvents;
    }

    public boolean isIgnoreAdminEvents() {
        return this.ignoreAdminEvents;
    }

    public void setIgnoreAdminEvents(boolean ignoreAdminEvents) {
        this.ignoreAdminEvents = ignoreAdminEvents;
    }

    public boolean isIgnoreConnectionEvents() {
        return this.ignoreConnectionEvents;
    }

    public void setIgnoreConnectionEvents(boolean ignoreConnectionEvents) {
        this.ignoreConnectionEvents = ignoreConnectionEvents;
    }

    public final void initialise() throws InitialisationException {
        UMOServerEventListener l;
        this.doInitialise();
        UMOManager manager = MuleManager.getInstance();
        if (!this.ignoreManagerEvents) {
            l = new ManagerEventListener(){

                public void onEvent(UMOServerEvent event) {
                    AbstractEventLoggerAgent.this.logEvent(event);
                }
            };
            manager.registerListener(l);
            this.listeners.add(l);
        }
        if (!this.ignoreModelEvents) {
            l = new ModelEventListener(){

                public void onEvent(UMOServerEvent event) {
                    AbstractEventLoggerAgent.this.logEvent(event);
                }
            };
            manager.registerListener(l);
            this.listeners.add(l);
        }
        if (!this.ignoreComponentEvents) {
            l = new ComponentEventListener(){

                public void onEvent(UMOServerEvent event) {
                    AbstractEventLoggerAgent.this.logEvent(event);
                }
            };
            manager.registerListener(l);
            this.listeners.add(l);
        }
        if (!this.ignoreSecurityEvents) {
            l = new SecurityEventListener(){

                public void onEvent(UMOServerEvent event) {
                    AbstractEventLoggerAgent.this.logEvent(event);
                }
            };
            manager.registerListener(l);
            this.listeners.add(l);
        }
        if (!this.ignoreManagementEvents) {
            l = new ManagementEventListener(){

                public void onEvent(UMOServerEvent event) {
                    AbstractEventLoggerAgent.this.logEvent(event);
                }
            };
            manager.registerListener(l);
            this.listeners.add(l);
        }
        if (!this.ignoreCustomEvents) {
            l = new CustomEventListener(){

                public void onEvent(UMOServerEvent event) {
                    AbstractEventLoggerAgent.this.logEvent(event);
                }
            };
            manager.registerListener(l);
            this.listeners.add(l);
        }
        if (!this.ignoreConnectionEvents) {
            l = new ConnectionEventListener(){

                public void onEvent(UMOServerEvent event) {
                    AbstractEventLoggerAgent.this.logEvent(event);
                }
            };
            manager.registerListener(l);
            this.listeners.add(l);
        }
        if (!this.ignoreAdminEvents) {
            l = new AdminEventListener(){

                public void onEvent(UMOServerEvent event) {
                    AbstractEventLoggerAgent.this.logEvent(event);
                }
            };
            manager.registerListener(l);
            this.listeners.add(l);
        }
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void logEvent(UMOServerEvent var1);
}

