/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.internal.events.AdminEvent;
import org.mule.providers.AbstractConnector;
import org.mule.transformers.xml.XmlToObject;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.PropertiesHelper;

public class MuleManagerComponent
implements Callable,
Initialisable {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$internal$admin$MuleManagerComponent == null ? (class$org$mule$impl$internal$admin$MuleManagerComponent = MuleManagerComponent.class$("org.mule.impl.internal.admin.MuleManagerComponent")) : class$org$mule$impl$internal$admin$MuleManagerComponent));
    public static final String MANAGER_COMPONENT_NAME = "_muleManagerComponent";
    public static final String MANAGER_PROVIDER_NAME = "_muleManagerProvider";
    private XmlToObject remoteTransformer;
    private XStream xstream;
    static /* synthetic */ Class class$org$mule$impl$internal$admin$MuleManagerComponent;
    static /* synthetic */ Class class$org$mule$impl$internal$events$AdminEvent;

    public void initialise() throws InitialisationException {
        this.xstream = new XStream((HierarchicalStreamDriver)new XppDriver());
        this.remoteTransformer = new XmlToObject();
        this.remoteTransformer.setReturnClass(class$org$mule$impl$internal$events$AdminEvent == null ? (class$org$mule$impl$internal$events$AdminEvent = MuleManagerComponent.class$("org.mule.impl.internal.events.AdminEvent")) : class$org$mule$impl$internal$events$AdminEvent);
    }

    public Object onCall(UMOEventContext context) throws Exception {
        Object result = null;
        String xml = context.getMessageAsString();
        logger.debug((Object)"Message received by MuleManagerComponent");
        AdminEvent action = (AdminEvent)this.remoteTransformer.transform(xml);
        if (604 == action.getAction()) {
            result = this.invokeAction(action, context);
        } else if (603 == action.getAction()) {
            result = this.sendAction(action, context);
        } else if (602 == action.getAction()) {
            result = this.sendAction(action, context);
        } else if (601 == action.getAction()) {
            result = this.receiveAction(action, context);
        } else {
            logger.error((Object)new MuleException(new Message(166, "AdminEvent:" + action.getAction())));
        }
        return result;
    }

    protected Object invokeAction(AdminEvent action, UMOEventContext context) throws UMOException {
        String destComponent = null;
        String endpoint = action.getResourceIdentifier();
        destComponent = action.getResourceIdentifier().startsWith("mule:") ? endpoint.substring(endpoint.lastIndexOf("/") + 1) : endpoint;
        if (destComponent != null) {
            UMOSession session = MuleManager.getInstance().getModel().getComponentSession(destComponent);
            RequestContext.rewriteEvent(action.getMessage());
            UMOEvent event = RequestContext.getEvent();
            event.getEndpoint().setTransformer(null);
            if (context.isSynchronous()) {
                UMOMessage result = session.getComponent().sendEvent(event);
                return this.xstream.toXML((Object)result);
            }
            session.getComponent().dispatchEvent(event);
            return null;
        }
        throw new MuleException(new Message(111, "org.mule.destination.component"));
    }

    protected Object sendAction(AdminEvent action, UMOEventContext context) throws UMOException {
        MuleEndpointURI endpointUri = new MuleEndpointURI(action.getResourceIdentifier());
        try {
            if (602 == action.getAction()) {
                context.dispatchEvent(action.getMessage(), endpointUri);
                return null;
            }
            UMOMessage result = context.sendEvent(action.getMessage(), endpointUri);
            if (result != null) {
                return this.xstream.toXML((Object)result);
            }
            return null;
        }
        catch (Exception e) {
            throw new DispatchException(action.getMessage(), new MuleEndpoint(action.getResourceIdentifier(), true), (Throwable)e);
        }
    }

    protected Object receiveAction(AdminEvent action, UMOEventContext context) throws UMOException {
        MuleEndpointURI endpointUri = new MuleEndpointURI(action.getResourceIdentifier());
        UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri(endpointUri, "sender");
        UMOMessageDispatcher dispatcher = endpoint.getConnector().getDispatcher(action.getResourceIdentifier());
        long timeout = PropertiesHelper.getLongProperty(action.getProperties(), "MULE_EVENT_TIMEOUT", MuleManager.getConfiguration().getSynchronousEventTimeout());
        try {
            MuleEndpointURI ep = new MuleEndpointURI(action.getResourceIdentifier());
            UMOMessage result = dispatcher.receive(ep, timeout);
            if (result != null) {
                UMOTransformer trans = ((AbstractConnector)endpoint.getConnector()).getDefaultInboundTransformer();
                if (trans != null) {
                    Object payload = trans.transform(result.getPayload());
                    result = new MuleMessage(payload, result.getProperties());
                }
                return this.xstream.toXML((Object)result);
            }
            return null;
        }
        catch (Exception e) {
            throw new ReceiveException(endpointUri, timeout, e);
        }
    }

    public static final UMODescriptor getDescriptor(UMOConnector connector, UMOEndpointURI endpointUri) throws UMOException {
        MuleEndpoint endpoint = new MuleEndpoint();
        endpoint.setConnector(connector);
        endpoint.setEndpointURI(endpointUri);
        endpoint.setName(MANAGER_PROVIDER_NAME);
        endpoint.setType("receiver");
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setName(MANAGER_COMPONENT_NAME);
        descriptor.setInboundEndpoint(endpoint);
        descriptor.setImplementation((class$org$mule$impl$internal$admin$MuleManagerComponent == null ? (class$org$mule$impl$internal$admin$MuleManagerComponent = MuleManagerComponent.class$("org.mule.impl.internal.admin.MuleManagerComponent")) : class$org$mule$impl$internal$admin$MuleManagerComponent).getName());
        descriptor.setContainerManaged(false);
        return descriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

