/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.RecoverableException;
import org.mule.umo.manager.UMOAgent;

public class RmiRegistryAgent
implements UMOAgent {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_SERVER_URI = "rmi://localhost:1099";
    private String name;
    private Registry rmiRegistry;
    private String serverUri = "rmi://localhost:1099";
    private boolean createRegistry = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Rmi Registry: " + this.serverUri;
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void start() throws UMOException {
        URI uri = null;
        try {
            uri = new URI(this.serverUri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (this.rmiRegistry == null) {
            try {
                if (this.createRegistry) {
                    try {
                        this.rmiRegistry = LocateRegistry.createRegistry(uri.getPort());
                    }
                    catch (ExportException e) {
                        this.logger.info((Object)("Registery on " + this.serverUri + " already bound. Attempting to use that instead"));
                        this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                    }
                } else {
                    this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                }
            }
            catch (RemoteException e) {
                throw new InitialisationException(e, (Object)this);
            }
        }
    }

    public void stop() throws UMOException {
        this.rmiRegistry = null;
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException, RecoverableException {
    }

    public Registry getRmiRegistry() {
        return this.rmiRegistry;
    }

    public void setRmiRegistry(Registry rmiRegistry) {
        this.rmiRegistry = rmiRegistry;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }

    public boolean isCreateRegistry() {
        return this.createRegistry;
    }

    public void setCreateRegistry(boolean createRegistry) {
        this.createRegistry = createRegistry;
    }
}

