/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.mbeans;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.MuleComponent;
import org.mule.management.mbeans.ComponentServiceMBean;
import org.mule.management.mbeans.ComponentStats;
import org.mule.umo.UMOException;
import org.mule.umo.UMOSession;

public class ComponentService
implements ComponentServiceMBean,
MBeanRegistration {
    private static transient Log LOGGER = LogFactory.getLog((Class)(class$org$mule$management$mbeans$ComponentService == null ? (class$org$mule$management$mbeans$ComponentService = ComponentService.class$("org.mule.management.mbeans.ComponentService")) : class$org$mule$management$mbeans$ComponentService));
    private MBeanServer server;
    private String name;
    private ObjectName statsName;
    private ObjectName objectName;
    static /* synthetic */ Class class$org$mule$management$mbeans$ComponentService;

    public ComponentService(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getQueueSize() {
        return this.getComponent().getQueueSize();
    }

    public void pause() throws UMOException {
        this.getComponent().pause();
    }

    public void resume() throws UMOException {
        this.getComponent().resume();
    }

    public boolean isPaused() {
        return this.getComponent().isPaused();
    }

    public boolean isStopped() {
        return this.getComponent().isStopped();
    }

    public void stop() throws UMOException {
        this.getComponent().stop();
    }

    public void forceStop() throws UMOException {
        this.getComponent().forceStop();
    }

    public boolean isStopping() {
        return this.getComponent().isStopping();
    }

    public void dispose() throws UMOException {
        this.getComponent().dispose();
    }

    public void start() throws UMOException {
        this.getComponent().start();
    }

    public ObjectName getStatistics() {
        return this.statsName;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        try {
            if (this.getComponent().getStatistics() != null) {
                this.statsName = new ObjectName(this.objectName.getDomain() + ":type=statistics,name=" + this.getName());
                if (this.server.isRegistered(this.statsName)) {
                    this.server.unregisterMBean(this.statsName);
                }
                this.server.registerMBean(new ComponentStats(this.getComponent().getStatistics()), this.statsName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error post-registering the MBean", (Throwable)e);
        }
    }

    public void preDeregister() throws Exception {
        try {
            if (this.server.isRegistered(this.statsName)) {
                this.server.unregisterMBean(this.statsName);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error unregistering ComponentService child " + this.statsName.getCanonicalName()), (Throwable)ex);
        }
    }

    public void postDeregister() {
    }

    private MuleComponent getComponent() {
        UMOSession session = MuleManager.getInstance().getModel().getComponentSession(this.getName());
        if (session == null) {
            return null;
        }
        return (MuleComponent)session.getComponent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

