/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats.printers;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.StringTokenizer;
import org.mule.management.stats.printers.AbstractTablePrinter;

public class HtmlTablePrinter
extends AbstractTablePrinter {
    public HtmlTablePrinter(Writer out) {
        super(out);
    }

    public HtmlTablePrinter(OutputStream out) {
        super(out);
    }

    public void print(Collection stats) {
        this.println("<font size='8'><table valign='top'>");
        String[][] table = this.getTable(stats);
        boolean endpointStats = false;
        for (int i = 0; i < table[0].length; ++i) {
            this.println("<tr valign='top'>");
            boolean bold = false;
            for (int j = 0; j < table.length; ++j) {
                if (j == 0 || i == 0 || "-".equals(table[j][i])) {
                    bold = true;
                    this.print("<td bgcolor='lightgray'><b>");
                } else {
                    bold = false;
                    this.print("<td>");
                }
                if (endpointStats) {
                    this.print(this.getProviderStatsHtml(table[j][i]));
                } else {
                    if (endpointStats) {
                        bold = true;
                        this.print("<b>");
                    }
                    this.print("-".equals(table[j][i]) ? "" : table[j][i]);
                }
                this.print((bold ? "</b>" : "") + "</td>");
            }
            this.println("</tr>");
            endpointStats = "By Provider".equals(table[0][i]);
        }
        this.println("</table></font>");
    }

    protected String getProviderStatsHtml(String stats) {
        if (stats == null || stats.trim().length() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<table>");
        StringTokenizer st = new StringTokenizer(stats, ";");
        if (st.countTokens() == 0) {
            buf.append("<tr><td>");
            int i = stats.indexOf("=");
            buf.append(stats.substring(0, i)).append(": ");
            buf.append("</td><td align=\"right'>");
            buf.append(stats.substring(i + 1));
            buf.append("</td></tr>");
        } else {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                buf.append("<tr><td>");
                int i = token.indexOf("=");
                buf.append(token.substring(0, i)).append(": ");
                buf.append("</td><td align=''right'>");
                buf.append(token.substring(i + 1));
                buf.append("</td></tr>");
            }
        }
        buf.append("</table>");
        return buf.toString();
    }
}

