/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.util.Map;
import java.util.Properties;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractConnector;
import org.mule.providers.service.ConnectorFactory;
import org.mule.providers.service.ConnectorServiceDescriptor;
import org.mule.providers.service.ConnectorServiceException;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.BeanUtils;
import org.mule.util.PropertiesHelper;

public abstract class AbstractServiceEnabledConnector
extends AbstractConnector {
    protected ConnectorServiceDescriptor serviceDescriptor;
    protected Properties serviceOverrides;

    public void doInitialise() throws InitialisationException {
        this.initFromServiceDescriptor();
    }

    public void initialiseFromUrl(UMOEndpointURI endpointUri) throws InitialisationException {
        String host;
        if (!this.getProtocol().equalsIgnoreCase(endpointUri.getScheme()) && !this.getProtocol().equalsIgnoreCase(endpointUri.getSchemeMetaInfo())) {
            throw new InitialisationException(new Message(115, this.getProtocol(), (Object)this.getClass().getName()), (Object)this);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)endpointUri.getParams());
        if (endpointUri.getUserInfo() != null) {
            props.setProperty("username", endpointUri.getUsername());
            String passwd = endpointUri.getPassword();
            if (passwd != null) {
                props.setProperty("password", passwd);
            }
        }
        if ((host = endpointUri.getHost()) != null) {
            props.setProperty("hostname", host);
            props.setProperty("host", host);
        }
        if (endpointUri.getPort() > -1) {
            props.setProperty("port", String.valueOf(endpointUri.getPort()));
        }
        BeanUtils.populateWithoutFail(this, props, true);
    }

    protected synchronized void initFromServiceDescriptor() throws InitialisationException {
        try {
            this.serviceDescriptor = ConnectorFactory.getServiceDescriptor(this.getProtocol().toLowerCase(), this.serviceOverrides);
            if (this.serviceDescriptor.getDispatcherFactory() != null) {
                this.logger.info((Object)("Loading DispatcherFactory: " + this.serviceDescriptor.getDispatcherFactory()));
                this.dispatcherFactory = this.serviceDescriptor.createDispatcherFactory();
            }
            this.defaultInboundTransformer = this.serviceDescriptor.createInboundTransformer();
            this.defaultOutboundTransformer = this.serviceDescriptor.createOutboundTransformer();
            this.defaultResponseTransformer = this.serviceDescriptor.createResponseTransformer();
            Map props = PropertiesHelper.getPropertiesWithPrefix(MuleManager.getInstance().getProperties(), this.getProtocol().toLowerCase());
            if (props.size() > 0) {
                props = PropertiesHelper.removeNamspaces(props);
                BeanUtils.populateWithoutFail(this, props, true);
            }
        }
        catch (Exception e) {
            throw new InitialisationException(e, (Object)this);
        }
    }

    protected ConnectorServiceDescriptor getServiceDescriptor() {
        if (this.serviceDescriptor == null) {
            throw new IllegalStateException("This connector has not yet been initialised: " + this.name);
        }
        return this.serviceDescriptor;
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        return this.getServiceDescriptor().createMessageReceiver(this, component, endpoint);
    }

    public UMOMessageAdapter getMessageAdapter(Object message) throws MessagingException {
        try {
            return this.serviceDescriptor.createMessageAdapter(message);
        }
        catch (ConnectorServiceException e) {
            throw new MessagingException(new Message(65, "Message Adapter"), message, (Throwable)e);
        }
    }

    public Map getServiceOverrides() {
        return this.serviceOverrides;
    }

    public void setServiceOverrides(Map serviceOverrides) {
        this.serviceOverrides = new Properties();
        this.serviceOverrides.putAll((Map<?, ?>)serviceOverrides);
    }
}

