/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.service;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.impl.endpoint.EndpointBuilder;
import org.mule.impl.endpoint.UrlEndpointBuilder;
import org.mule.providers.NullPayload;
import org.mule.providers.service.ConnectorFactoryException;
import org.mule.providers.service.ConnectorServiceException;
import org.mule.providers.service.ConnectorServiceFinder;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransactionFactory;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcherFactory;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassHelper;
import org.mule.util.ObjectFactory;

public class ConnectorServiceDescriptor {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$service$ConnectorServiceDescriptor == null ? (class$org$mule$providers$service$ConnectorServiceDescriptor = ConnectorServiceDescriptor.class$("org.mule.providers.service.ConnectorServiceDescriptor")) : class$org$mule$providers$service$ConnectorServiceDescriptor));
    private String protocol;
    private String serviceLocation;
    private String serviceError;
    private String serviceFinder;
    private String connector;
    private String connectorFactory;
    private String dispatcherFactory;
    private String transactionFactory;
    private String messageAdapter;
    private String messageReceiver;
    private String endpointBuilder;
    private String defaultInboundTransformer;
    private String defaultOutboundTransformer;
    private String defaultResponseTransformer;
    private Properties properties;
    private UMOTransformer inboundTransformer;
    private UMOTransformer outboundTransformer;
    private UMOTransformer responseTransformer;
    private ConnectorServiceFinder connectorServiceFinder;
    static /* synthetic */ Class class$org$mule$providers$service$ConnectorServiceDescriptor;
    static /* synthetic */ Class class$org$mule$providers$service$ConnectorFactory;
    static /* synthetic */ Class class$org$mule$impl$endpoint$UrlEndpointBuilder;

    public ConnectorServiceDescriptor(String protocol, String serviceLocation, Properties props) {
        this.protocol = protocol;
        this.serviceLocation = serviceLocation;
        this.properties = props;
        this.serviceError = this.removeProperty("service.error");
        this.connector = this.removeProperty("connector");
        this.connectorFactory = this.removeProperty("connector.factory");
        this.dispatcherFactory = this.removeProperty("dispatcher.factory");
        this.transactionFactory = this.removeProperty("dispatcher.factory");
        this.messageReceiver = this.removeProperty("message.receiver");
        this.messageAdapter = this.removeProperty("message.adapter");
        this.defaultInboundTransformer = this.removeProperty("inbound.transformer");
        this.defaultOutboundTransformer = this.removeProperty("outbound.transformer");
        this.defaultResponseTransformer = this.removeProperty("response.transformer");
        this.endpointBuilder = this.removeProperty("endpoint.builder");
        this.serviceFinder = this.removeProperty("service.finder");
    }

    void setOverrides(Properties props) {
        if (props == null || props.size() == 0) {
            return;
        }
        this.serviceError = props.getProperty("service.error", this.serviceError);
        this.connector = props.getProperty("connector", this.connector);
        this.connectorFactory = props.getProperty("connector.factory", this.connectorFactory);
        this.dispatcherFactory = props.getProperty("dispatcher.factory", this.dispatcherFactory);
        this.messageReceiver = props.getProperty("message.receiver", this.messageReceiver);
        this.messageAdapter = props.getProperty("message.adapter", this.messageAdapter);
        String temp = props.getProperty("inbound.transformer");
        if (temp != null) {
            this.defaultInboundTransformer = temp;
            this.inboundTransformer = null;
        }
        if ((temp = props.getProperty("outbound.transformer")) != null) {
            this.defaultOutboundTransformer = temp;
            this.outboundTransformer = null;
        }
        if ((temp = props.getProperty("response.transformer")) != null) {
            this.defaultResponseTransformer = temp;
            this.responseTransformer = null;
        }
        if ((temp = props.getProperty("endpoint.builder")) != null) {
            this.endpointBuilder = temp;
        }
        if ((temp = props.getProperty("service.finder")) != null) {
            this.serviceFinder = temp;
            this.connectorServiceFinder = null;
        }
    }

    private String removeProperty(String name) {
        String temp = (String)this.properties.remove(name);
        if (temp != null && temp.trim().length() == 0) {
            return null;
        }
        return temp;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getServiceLocation() {
        return this.serviceLocation;
    }

    public String getServiceError() {
        return this.serviceError;
    }

    public String getConnector() {
        return this.connector;
    }

    public String getConnectorFactory() {
        return this.connectorFactory;
    }

    public String getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public String getMessageReceiver() {
        return this.messageReceiver;
    }

    public String getDefaultInboundTransformer() {
        return this.defaultInboundTransformer;
    }

    public String getDefaultOutboundTransformer() {
        return this.defaultOutboundTransformer;
    }

    public String getMessageAdapter() {
        return this.messageAdapter;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getEndpointBuilder() {
        return this.endpointBuilder;
    }

    public String getServiceFinder() {
        return this.serviceFinder;
    }

    public ConnectorServiceFinder createServiceFinder() throws ConnectorServiceException {
        if (this.serviceFinder == null) {
            return null;
        }
        if (this.connectorServiceFinder == null) {
            try {
                this.connectorServiceFinder = (ConnectorServiceFinder)ClassHelper.instanciateClass(this.serviceFinder, ClassHelper.NO_ARGS);
            }
            catch (Exception e) {
                throw new ConnectorServiceException(new Message(73, this.serviceFinder), (Throwable)e);
            }
        }
        return this.connectorServiceFinder;
    }

    public String getDefaultResponseTransformer() {
        return this.defaultResponseTransformer;
    }

    public UMOMessageAdapter createMessageAdapter(Object message) throws ConnectorServiceException {
        if (message == null) {
            message = new NullPayload();
        }
        if (this.messageAdapter != null) {
            try {
                return (UMOMessageAdapter)ClassHelper.instanciateClass(this.messageAdapter, new Object[]{message});
            }
            catch (Exception e) {
                throw new ConnectorServiceException(new Message(74, "Message Adapter", (Object)this.messageAdapter), (Throwable)e);
            }
        }
        throw new ConnectorServiceException(new Message(75, "Message Adapter", (Object)this.getProtocol()));
    }

    public UMOMessageReceiver createMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws UMOException {
        return this.createMessageReceiver(connector, component, endpoint, null);
    }

    public UMOMessageReceiver createMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Object[] args) throws UMOException {
        if (this.messageReceiver != null) {
            Object[] newArgs = null;
            newArgs = args != null && args.length != 0 ? new Object[3 + args.length] : new Object[]{connector, component, endpoint};
            if (args != null && args.length != 0) {
                System.arraycopy(args, 0, newArgs, 3, newArgs.length - 3);
            }
            try {
                return (UMOMessageReceiver)ClassHelper.instanciateClass(this.messageReceiver, newArgs);
            }
            catch (Exception e) {
                throw new ConnectorServiceException(new Message(74, "Message Receiver", (Object)this.getProtocol()), (Throwable)e);
            }
        }
        throw new ConnectorServiceException(new Message(75, "Message Receiver", (Object)this.getProtocol()));
    }

    public UMOMessageDispatcherFactory createDispatcherFactory() throws ConnectorServiceException {
        if (this.dispatcherFactory != null) {
            try {
                return (UMOMessageDispatcherFactory)ClassHelper.instanciateClass(this.dispatcherFactory, ClassHelper.NO_ARGS);
            }
            catch (Exception e) {
                throw new ConnectorServiceException(new Message(74, "Message Dispatcher Factory", (Object)this.dispatcherFactory), (Throwable)e);
            }
        }
        throw new ConnectorServiceException(new Message(75, "Message Dispatcher Factory", (Object)this.getProtocol()));
    }

    public UMOTransactionFactory createTransactionFactory() throws ConnectorServiceException {
        if (this.transactionFactory != null) {
            try {
                return (UMOTransactionFactory)ClassHelper.instanciateClass(this.transactionFactory, ClassHelper.NO_ARGS);
            }
            catch (Exception e) {
                throw new ConnectorServiceException(new Message(74, "Transaction Factory", (Object)this.transactionFactory), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public UMOConnector createConnector(String protocol) throws ConnectorServiceException {
        void var2_5;
        block7: {
            if (this.getServiceError() != null) {
                throw new ConnectorServiceException(Message.createStaticMessage(this.getServiceError()));
            }
            try {
                UMOConnector connector;
                if (this.getConnectorFactory() != null) {
                    ObjectFactory factory = (ObjectFactory)ClassHelper.loadClass(this.getConnectorFactory(), class$org$mule$providers$service$ConnectorFactory == null ? (class$org$mule$providers$service$ConnectorFactory = ConnectorServiceDescriptor.class$("org.mule.providers.service.ConnectorFactory")) : class$org$mule$providers$service$ConnectorFactory).newInstance();
                    connector = (UMOConnector)factory.create();
                    break block7;
                }
                if (this.getConnector() != null) {
                    connector = (UMOConnector)ClassHelper.loadClass(this.getConnector(), class$org$mule$providers$service$ConnectorFactory == null ? (class$org$mule$providers$service$ConnectorFactory = ConnectorServiceDescriptor.class$("org.mule.providers.service.ConnectorFactory")) : class$org$mule$providers$service$ConnectorFactory).newInstance();
                    break block7;
                }
                throw new ConnectorServiceException(new Message(75, "Connector", (Object)this.getProtocol()));
            }
            catch (ConnectorServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConnectorServiceException(new Message(74, "Connector", (Object)this.getConnector()), (Throwable)e);
            }
        }
        if (var2_5.getName() == null) {
            var2_5.setName("_" + protocol + "Connector#" + var2_5.hashCode());
        }
        return var2_5;
    }

    public UMOTransformer createInboundTransformer() throws ConnectorFactoryException {
        if (this.inboundTransformer != null) {
            return this.inboundTransformer;
        }
        if (this.getDefaultInboundTransformer() != null) {
            logger.info((Object)("Loading default inbound transformer: " + this.getDefaultInboundTransformer()));
            try {
                this.inboundTransformer = (UMOTransformer)ClassHelper.instanciateClass(this.getDefaultInboundTransformer(), ClassHelper.NO_ARGS);
                return this.inboundTransformer;
            }
            catch (Exception e) {
                throw new ConnectorFactoryException(new Message(57, "inbound", (Object)this.getDefaultInboundTransformer()), (Throwable)e);
            }
        }
        return null;
    }

    public UMOTransformer createOutboundTransformer() throws ConnectorFactoryException {
        if (this.outboundTransformer != null) {
            return this.outboundTransformer;
        }
        if (this.getDefaultOutboundTransformer() != null) {
            logger.info((Object)("Loading default outbound transformer: " + this.getDefaultInboundTransformer()));
            try {
                this.outboundTransformer = (UMOTransformer)ClassHelper.instanciateClass(this.getDefaultOutboundTransformer(), ClassHelper.NO_ARGS);
                return this.outboundTransformer;
            }
            catch (Exception e) {
                throw new ConnectorFactoryException(new Message(57, "outbound", (Object)this.getDefaultOutboundTransformer()), (Throwable)e);
            }
        }
        return null;
    }

    public UMOTransformer createResponseTransformer() throws ConnectorFactoryException {
        if (this.responseTransformer != null) {
            return this.responseTransformer;
        }
        if (this.getDefaultResponseTransformer() != null) {
            logger.info((Object)("Loading default response transformer: " + this.getDefaultResponseTransformer()));
            try {
                this.responseTransformer = (UMOTransformer)ClassHelper.instanciateClass(this.getDefaultResponseTransformer(), ClassHelper.NO_ARGS);
                return this.responseTransformer;
            }
            catch (Exception e) {
                throw new ConnectorFactoryException(new Message(57, "response", (Object)this.getDefaultResponseTransformer()), (Throwable)e);
            }
        }
        return null;
    }

    public EndpointBuilder createEndpointBuilder() throws ConnectorFactoryException {
        if (this.endpointBuilder == null) {
            logger.debug((Object)("Endpoint resolver not set, Loading default resolver: " + (class$org$mule$impl$endpoint$UrlEndpointBuilder == null ? (class$org$mule$impl$endpoint$UrlEndpointBuilder = ConnectorServiceDescriptor.class$("org.mule.impl.endpoint.UrlEndpointBuilder")) : class$org$mule$impl$endpoint$UrlEndpointBuilder).getName()));
            return new UrlEndpointBuilder();
        }
        logger.debug((Object)("Loading endpointUri resolver: " + this.getEndpointBuilder()));
        try {
            return (EndpointBuilder)ClassHelper.instanciateClass(this.getEndpointBuilder(), ClassHelper.NO_ARGS);
        }
        catch (Exception e) {
            throw new ConnectorFactoryException(new Message(58, "Endpoint Builder: " + this.getEndpointBuilder()), (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectorServiceDescriptor)) {
            return false;
        }
        ConnectorServiceDescriptor connectorServiceDescriptor = (ConnectorServiceDescriptor)o;
        if (this.connector != null ? !this.connector.equals(connectorServiceDescriptor.connector) : connectorServiceDescriptor.connector != null) {
            return false;
        }
        if (this.connectorFactory != null ? !this.connectorFactory.equals(connectorServiceDescriptor.connectorFactory) : connectorServiceDescriptor.connectorFactory != null) {
            return false;
        }
        if (this.defaultInboundTransformer != null ? !this.defaultInboundTransformer.equals(connectorServiceDescriptor.defaultInboundTransformer) : connectorServiceDescriptor.defaultInboundTransformer != null) {
            return false;
        }
        if (this.defaultOutboundTransformer != null ? !this.defaultOutboundTransformer.equals(connectorServiceDescriptor.defaultOutboundTransformer) : connectorServiceDescriptor.defaultOutboundTransformer != null) {
            return false;
        }
        if (this.defaultResponseTransformer != null ? !this.defaultResponseTransformer.equals(connectorServiceDescriptor.defaultResponseTransformer) : connectorServiceDescriptor.defaultResponseTransformer != null) {
            return false;
        }
        if (this.dispatcherFactory != null ? !this.dispatcherFactory.equals(connectorServiceDescriptor.dispatcherFactory) : connectorServiceDescriptor.dispatcherFactory != null) {
            return false;
        }
        if (this.endpointBuilder != null ? !this.endpointBuilder.equals(connectorServiceDescriptor.endpointBuilder) : connectorServiceDescriptor.endpointBuilder != null) {
            return false;
        }
        if (this.messageAdapter != null ? !this.messageAdapter.equals(connectorServiceDescriptor.messageAdapter) : connectorServiceDescriptor.messageAdapter != null) {
            return false;
        }
        if (this.messageReceiver != null ? !this.messageReceiver.equals(connectorServiceDescriptor.messageReceiver) : connectorServiceDescriptor.messageReceiver != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(connectorServiceDescriptor.protocol) : connectorServiceDescriptor.protocol != null) {
            return false;
        }
        if (this.serviceError != null ? !this.serviceError.equals(connectorServiceDescriptor.serviceError) : connectorServiceDescriptor.serviceError != null) {
            return false;
        }
        if (this.serviceFinder != null ? !this.serviceFinder.equals(connectorServiceDescriptor.serviceFinder) : connectorServiceDescriptor.serviceFinder != null) {
            return false;
        }
        if (this.serviceLocation != null ? !this.serviceLocation.equals(connectorServiceDescriptor.serviceLocation) : connectorServiceDescriptor.serviceLocation != null) {
            return false;
        }
        return !(this.transactionFactory != null ? !this.transactionFactory.equals(connectorServiceDescriptor.transactionFactory) : connectorServiceDescriptor.transactionFactory != null);
    }

    public int hashCode() {
        int result = this.protocol != null ? this.protocol.hashCode() : 0;
        result = 29 * result + (this.serviceLocation != null ? this.serviceLocation.hashCode() : 0);
        result = 29 * result + (this.serviceError != null ? this.serviceError.hashCode() : 0);
        result = 29 * result + (this.serviceFinder != null ? this.serviceFinder.hashCode() : 0);
        result = 29 * result + (this.connector != null ? this.connector.hashCode() : 0);
        result = 29 * result + (this.connectorFactory != null ? this.connectorFactory.hashCode() : 0);
        result = 29 * result + (this.dispatcherFactory != null ? this.dispatcherFactory.hashCode() : 0);
        result = 29 * result + (this.transactionFactory != null ? this.transactionFactory.hashCode() : 0);
        result = 29 * result + (this.messageAdapter != null ? this.messageAdapter.hashCode() : 0);
        result = 29 * result + (this.messageReceiver != null ? this.messageReceiver.hashCode() : 0);
        result = 29 * result + (this.endpointBuilder != null ? this.endpointBuilder.hashCode() : 0);
        result = 29 * result + (this.defaultInboundTransformer != null ? this.defaultInboundTransformer.hashCode() : 0);
        result = 29 * result + (this.defaultOutboundTransformer != null ? this.defaultOutboundTransformer.hashCode() : 0);
        result = 29 * result + (this.defaultResponseTransformer != null ? this.defaultResponseTransformer.hashCode() : 0);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

