/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.PropertyExtractor;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.CorrelationPropertiesExtractor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.UMOOutboundRouter;

public abstract class AbstractOutboundRouter
implements UMOOutboundRouter {
    public static final int ENABLE_CORRELATION_IF_NOT_SET = 0;
    public static final int ENABLE_CORRELATION_ALWAYS = 1;
    public static final int ENABLE_CORRELATION_NEVER = 2;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List endpoints = new CopyOnWriteArrayList();
    protected String replyTo = null;
    protected int enableCorrelation = 0;
    protected PropertyExtractor propertyExtractor = new CorrelationPropertiesExtractor();
    protected RouterStatistics routerStatistics;
    protected UMOTransactionConfig transactionConfig;

    public void dispatch(UMOSession session, UMOMessage message, UMOEndpoint endpoint) throws UMOException {
        this.setMessageProperties(session, message, endpoint);
        session.dispatchEvent(message, endpoint);
        if (this.routerStatistics != null && this.routerStatistics.isEnabled()) {
            this.routerStatistics.incrementRoutedMessage(endpoint);
        }
    }

    public UMOMessage send(UMOSession session, UMOMessage message, UMOEndpoint endpoint) throws UMOException {
        if (this.replyTo != null) {
            this.logger.debug((Object)"event was dispatched synchronously, but there is a ReplyTo endpoint set, so using ");
            this.dispatch(session, message, endpoint);
            return null;
        }
        this.setMessageProperties(session, message, endpoint);
        UMOMessage result = session.sendEvent(message, endpoint);
        if (this.routerStatistics != null && this.routerStatistics.isEnabled()) {
            this.routerStatistics.incrementRoutedMessage(endpoint);
        }
        return result;
    }

    protected void setMessageProperties(UMOSession session, UMOMessage message, UMOEndpoint endpoint) {
        if (this.replyTo != null) {
            message.setReplyTo(this.replyTo);
            message.setProperty("MULE_REPLYTO_REQUESTOR", session.getComponent().getDescriptor().getName());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting replyTo=" + this.replyTo + " for outbound endpoint: " + endpoint.getEndpointURI()));
            }
        }
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting it again");
                return;
            }
            if (correlationSet) {
                this.logger.debug((Object)"CorrelationId is already set, but router is configured to overwrite it");
            }
            String correlation = null;
            Object o = this.propertyExtractor.getProperty("MULE_CORRELATION_ID", message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Extracted correlation Id as: " + o));
            }
            correlation = o.toString();
            boolean seq = true;
            boolean group = true;
            if (this.logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Setting Correlation info on Outbound router for endpoint: ").append(endpoint.getEndpointURI());
                buf.append("\n").append("Id=").append(correlation);
                this.logger.debug((Object)buf.toString());
            }
            message.setCorrelationId(correlation);
        }
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        this.endpoints = new CopyOnWriteArrayList((Collection)endpoints);
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        endpoint.setType("sender");
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(UMOEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo != null ? MuleManager.getInstance().lookupEndpointIdentifier(replyTo, replyTo) : null;
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    public void setRouterStatistics(RouterStatistics routerStatistics) {
        this.routerStatistics = routerStatistics;
    }

    public int getEnableCorrelation() {
        return this.enableCorrelation;
    }

    public void setEnableCorrelation(int enableCorrelation) {
        this.enableCorrelation = enableCorrelation;
    }

    public void setEnableCorrelationAsString(String enableCorrelation) {
        if (enableCorrelation != null) {
            if (enableCorrelation.equals("ALWAYS")) {
                this.enableCorrelation = 1;
            } else if (enableCorrelation.equals("NEVER")) {
                this.enableCorrelation = 2;
            } else if (enableCorrelation.equals("IF_NOT_SET")) {
                this.enableCorrelation = 0;
            } else {
                throw new IllegalArgumentException("Value for enableCorrelation not recognised: " + enableCorrelation);
            }
        }
    }

    public PropertyExtractor getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public UMOTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setTransactionConfig(UMOTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public boolean isDynamicEndpoints() {
        return false;
    }
}

