/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseAggregator;
import org.mule.umo.UMOEvent;

public abstract class ResponseCorrelationAggregator
extends AbstractResponseAggregator {
    protected boolean shouldAggregate(EventGroup events) {
        int size = events.getExpectedSize();
        if (size == -1) {
            this.logger.warn((Object)"Correlation Group Size not set, but CorrelationAggregator is being used.  Message is being forwarded");
            return true;
        }
        this.logger.info((Object)("Aggregator: Current Event groups = " + this.eventGroups.size()));
        this.logger.info((Object)("correlation size is " + size + ". current event group size is " + events.getSize() + " for correlation " + events.getGroupId()));
        return size == events.getSize();
    }

    protected EventGroup createEventGroup(Object id, UMOEvent event) {
        int groupSize = event.getMessage().getCorrelationGroupSize();
        return new EventGroup(id, groupSize);
    }
}

