/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.model;

import junit.framework.Assert;
import org.mule.impl.MuleDescriptor;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.model.UMOPoolFactory;
import org.mule.util.ObjectPool;

public abstract class AbstractPoolTestCase
extends AbstractMuleTestCase {
    public static final byte FAIL_WHEN_EXHAUSTED = 0;
    public static final byte GROW_WHEN_EXHAUSTED = 1;
    public static final byte BLOCK_WHEN_EXHAUSTED = 2;
    public static final byte DEFAULT_POOL_SIZE = 3;
    public static final long DEFAULT_WAIT = 1500L;
    static /* synthetic */ Class class$org$mule$tck$testmodels$fruit$Orange;

    protected void doSetUp() throws Exception {
        AbstractPoolTestCase.getManager();
    }

    public void testCreatePool() throws Exception {
        MuleDescriptor d = AbstractPoolTestCase.getTestDescriptor("orange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractPoolTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName());
        ObjectPool pool = this.createPool(d, (byte)0);
        AbstractPoolTestCase.assertNotNull((Object)pool);
        AbstractPoolTestCase.assertEquals((int)0, (int)pool.getSize());
        Object borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull((Object)borrowed);
        AbstractPoolTestCase.assertEquals((int)1, (int)pool.getSize());
        pool.returnObject(borrowed);
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull((Object)borrowed);
        AbstractPoolTestCase.assertEquals((int)1, (int)pool.getSize());
        Object borrowed2 = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull((Object)borrowed2);
        AbstractPoolTestCase.assertEquals((int)2, (int)pool.getSize());
    }

    public void testFailOnExhaust() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractPoolTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName()), (byte)0);
        Object borrowed = null;
        for (int i = 0; i < pool.getMaxSize(); ++i) {
            borrowed = pool.borrowObject();
            AbstractPoolTestCase.assertNotNull((Object)borrowed);
            AbstractPoolTestCase.assertEquals((int)pool.getSize(), (int)(i + 1));
        }
        try {
            borrowed = pool.borrowObject();
            AbstractPoolTestCase.fail((String)"Should throw an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBlockExpiryOnExhaust() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractPoolTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName()), (byte)2);
        Object borrowed = null;
        AbstractPoolTestCase.assertEquals((int)0, (int)pool.getSize());
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull((Object)borrowed);
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull((Object)borrowed);
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull((Object)borrowed);
        AbstractPoolTestCase.assertEquals((int)3, (int)pool.getSize());
        try {
            borrowed = pool.borrowObject();
            AbstractPoolTestCase.fail((String)"Should throw an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBlockOnExhaust() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractPoolTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName()), (byte)2);
        Object borrowed = null;
        AbstractPoolTestCase.assertEquals((int)0, (int)pool.getSize());
        borrowed = pool.borrowObject();
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertEquals((int)2, (int)pool.getSize());
        long borrowerWait = 500L;
        Borrower borrower = new Borrower(pool, borrowerWait);
        borrower.start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull((Object)borrowed);
    }

    public void testGrowOnExhaust() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractPoolTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName()), (byte)1);
        Object borrowed = pool.borrowObject();
        borrowed = pool.borrowObject();
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertEquals((int)3, (int)pool.getSize());
        AbstractPoolTestCase.assertEquals((int)3, (int)pool.getMaxSize());
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull((Object)borrowed);
        AbstractPoolTestCase.assertEquals((int)4, (int)pool.getSize());
    }

    public void testClearPool() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractPoolTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName()), (byte)0);
        Object borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertEquals((int)1, (int)pool.getSize());
        pool.returnObject(borrowed);
        pool.clearPool();
        AbstractPoolTestCase.assertEquals((int)0, (int)pool.getSize());
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertEquals((int)1, (int)pool.getSize());
    }

    public void testCreateFromFactory() throws Exception {
        MuleDescriptor descriptor = AbstractPoolTestCase.getTestDescriptor("orange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractPoolTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName());
        UMOPoolFactory factory = this.getPoolFactory();
        ObjectPool pool = factory.createPool(descriptor);
        AbstractPoolTestCase.assertNotNull((Object)pool);
    }

    public void testPoolLifecycle() throws Exception {
        MuleDescriptor d = AbstractPoolTestCase.getTestDescriptor("orange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractPoolTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName());
        ObjectPool pool = this.createPool(d, (byte)0);
        AbstractPoolTestCase.assertNotNull((Object)pool);
        AbstractPoolTestCase.assertEquals((int)0, (int)pool.getSize());
    }

    public abstract ObjectPool createPool(MuleDescriptor var1, byte var2) throws InitialisationException;

    public abstract UMOPoolFactory getPoolFactory();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Borrower
    extends Thread {
        private ObjectPool pool;
        private long time;

        public Borrower(ObjectPool pool, long time) {
            super("Borrower");
            if (pool == null) {
                throw new IllegalArgumentException("Pool cannot be null");
            }
            this.pool = pool;
            if (time < 500L) {
                time = 500L;
            }
            this.time = time;
        }

        public void run() {
            try {
                Object object = this.pool.borrowObject();
                try {
                    Borrower.sleep(this.time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.pool.returnObject(object);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Borrower thread failed");
            }
        }
    }
}

