/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import org.mule.config.i18n.Message;
import org.mule.transaction.AbstractTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionStatusException;
import org.mule.umo.TransactionException;

public abstract class AbstractSingleResourceTransaction
extends AbstractTransaction {
    protected Object key;
    protected Object resource;
    protected SynchronizedBoolean started = new SynchronizedBoolean(false);
    protected SynchronizedBoolean committed = new SynchronizedBoolean(false);
    protected SynchronizedBoolean rolledBack = new SynchronizedBoolean(false);
    protected SynchronizedBoolean rollbackOnly = new SynchronizedBoolean(false);

    public void begin() throws TransactionException {
        super.begin();
        this.started.commit(false, true);
    }

    public void commit() throws TransactionException {
        super.commit();
        this.committed.commit(false, true);
    }

    public void rollback() throws TransactionException {
        super.rollback();
        this.rolledBack.commit(false, true);
    }

    public int getStatus() throws TransactionStatusException {
        if (this.rolledBack.get()) {
            return 4;
        }
        if (this.committed.get()) {
            return 3;
        }
        if (this.rollbackOnly.get()) {
            return 1;
        }
        if (this.started.get()) {
            return 0;
        }
        return 6;
    }

    public Object getResource(Object key) {
        return key != null && this.key == key ? this.resource : null;
    }

    public boolean hasResource(Object key) {
        return key != null && this.key == key;
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (key == null) {
            throw new IllegalTransactionStateException(new Message(78));
        }
        if (resource == null) {
            throw new IllegalTransactionStateException(new Message(79));
        }
        if (this.key != null) {
            throw new IllegalTransactionStateException(new Message(80));
        }
        this.key = key;
        this.resource = resource;
    }

    public void setRollbackOnly() {
        this.rollbackOnly.set(true);
    }

    public Object getId() {
        return this.key;
    }

    protected abstract void doBegin() throws TransactionException;

    protected abstract void doCommit() throws TransactionException;

    protected abstract void doRollback() throws TransactionException;
}

