/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOException;
import org.mule.util.ClassHelper;
import org.mule.util.PropertiesHelper;
import org.mule.util.SpiHelper;
import org.mule.util.Utility;

public class ExceptionHelper {
    public static final String ERROR_CODE_PROPERTY = "error.code.property";
    public static final String APPLY_TO_PROPERTY = "apply.to";
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$config$ExceptionHelper == null ? (class$org$mule$config$ExceptionHelper = ExceptionHelper.class$("org.mule.config.ExceptionHelper")) : class$org$mule$config$ExceptionHelper));
    private static Properties errorDocs = new Properties();
    private static Properties errorCodes = new Properties();
    private static Map reverseErrorCodes = null;
    private static Map errorMappings = new HashMap();
    private static int exceptionThreshold = 0;
    private static boolean verbose = true;
    private static boolean initialised = false;
    private static String J2SE_VERSION = "";
    private static String J2EE_VERSION = "";
    static /* synthetic */ Class class$org$mule$config$ExceptionHelper;
    static /* synthetic */ Class class$java$lang$Object;

    public static int getErrorCode(Class exception) {
        String code = errorCodes.getProperty(exception.getName(), "-1");
        return Integer.parseInt(code);
    }

    public static Class getErrorClass(int code) {
        String key = String.valueOf(code);
        Object clazz = reverseErrorCodes.get(key);
        if (clazz == null) {
            return null;
        }
        if (clazz instanceof Class) {
            return (Class)clazz;
        }
        try {
            clazz = ClassHelper.loadClass(clazz.toString(), class$org$mule$config$ExceptionHelper == null ? (class$org$mule$config$ExceptionHelper = ExceptionHelper.class$("org.mule.config.ExceptionHelper")) : class$org$mule$config$ExceptionHelper);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        reverseErrorCodes.put(key, clazz);
        return (Class)clazz;
    }

    public static String getErrorMapping(String protocol, int code) {
        Class c = ExceptionHelper.getErrorClass(code);
        if (c != null) {
            return ExceptionHelper.getErrorMapping(protocol, c);
        }
        logger.error((Object)("Class not known for code: " + code));
        return "-1";
    }

    private static Properties getErrorMappings(String protocol) {
        Object m = errorMappings.get(protocol);
        if (m != null) {
            if (m instanceof Properties) {
                return (Properties)m;
            }
            return null;
        }
        InputStream is = SpiHelper.findServiceDescriptor("org/mule/config", protocol + "-exception-mappings.properties", class$org$mule$config$ExceptionHelper == null ? (class$org$mule$config$ExceptionHelper = ExceptionHelper.class$("org.mule.config.ExceptionHelper")) : class$org$mule$config$ExceptionHelper);
        if (is == null) {
            errorMappings.put(protocol, "not found");
            logger.warn((Object)("Failed to load error mappings from: META-INF/services/org/mule/config/" + protocol + "-exception-mappings.properties. This may be because there are no error code mappings for protocol: " + protocol));
            return null;
        }
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException e) {
            throw new MuleRuntimeException(Message.createStaticMessage("Failed to load Exception resources"), (Throwable)e);
        }
        errorMappings.put(protocol, p);
        String applyTo = p.getProperty(APPLY_TO_PROPERTY, null);
        if (applyTo != null) {
            String[] protocols = Utility.split(applyTo, ",");
            for (int i = 0; i < protocols.length; ++i) {
                errorMappings.put(protocols[i], p);
            }
        }
        return p;
    }

    public static String getErrorCodePropertyName(String protocol) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase());
        if (mappings == null) {
            return null;
        }
        return mappings.getProperty(ERROR_CODE_PROPERTY);
    }

    public static String getErrorMapping(String protocol, Class exception) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase());
        if (mappings == null) {
            logger.info((Object)("No mappings found for protocol: " + protocol));
            return String.valueOf(ExceptionHelper.getErrorCode(exception));
        }
        Class clazz = exception;
        String code = null;
        while (!clazz.equals(class$java$lang$Object == null ? ExceptionHelper.class$("java.lang.Object") : class$java$lang$Object)) {
            code = mappings.getProperty(clazz.getName());
            if (code == null) {
                clazz = clazz.getSuperclass();
                continue;
            }
            return code;
        }
        code = String.valueOf(ExceptionHelper.getErrorCode(exception));
        return mappings.getProperty(code, code);
    }

    public static void initialise() {
        try {
            InputStream is;
            if (initialised) {
                return;
            }
            J2SE_VERSION = System.getProperty("java.version");
            int i = J2SE_VERSION.indexOf("_");
            if (i > 0) {
                J2SE_VERSION = J2SE_VERSION.substring(0, i);
            }
            if ((is = SpiHelper.findServiceDescriptor("org/mule/config", "mule-exception-codes.properties", class$org$mule$config$ExceptionHelper == null ? (class$org$mule$config$ExceptionHelper = ExceptionHelper.class$("org.mule.config.ExceptionHelper")) : class$org$mule$config$ExceptionHelper)) == null) {
                throw new NullPointerException("Failed to load resource: META_INF/services/org/mule/config/mule-exception-codes.properties");
            }
            errorCodes.load(is);
            reverseErrorCodes = PropertiesHelper.reverseProperties(errorCodes);
            is = SpiHelper.findServiceDescriptor("org/mule/config", "mule-exception-config.properties", class$org$mule$config$ExceptionHelper == null ? (class$org$mule$config$ExceptionHelper = ExceptionHelper.class$("org.mule.config.ExceptionHelper")) : class$org$mule$config$ExceptionHelper);
            if (is == null) {
                throw new NullPointerException("Failed to load resource: META_INF/services/org/mule/config/mule-exception-config.properties");
            }
            errorDocs.load(is);
            initialised = true;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(Message.createStaticMessage("Failed to load Exception resources"), (Throwable)e);
        }
    }

    public static String getJavaDocUrl(Class exception) {
        return ExceptionHelper.getDocUrl("javadoc.", exception.getName());
    }

    public static String getDocUrl(Class exception) {
        return ExceptionHelper.getDocUrl("doc.", exception.getName());
    }

    private static String getDocUrl(String prefix, String packageName) {
        String key = prefix;
        if (packageName.startsWith("java.")) {
            key = key + J2SE_VERSION;
        } else if (packageName.startsWith("javax.")) {
            key = key + J2EE_VERSION;
        }
        String url = ExceptionHelper.getUrl(key, packageName);
        if (url == null && packageName.startsWith("javax.")) {
            url = ExceptionHelper.getUrl(key, packageName.replaceFirst("javax", "java"));
        }
        if (url != null) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            String s = packageName.replaceAll("[.]", "/");
            s = s + ".html";
            url = url + s;
        }
        if (logger.isDebugEnabled()) {
            if ("javadoc".equalsIgnoreCase(prefix)) {
                logger.debug((Object)("Javadoc Url for package '" + packageName + "' is: " + url));
            } else if ("doc".equalsIgnoreCase(prefix)) {
                logger.debug((Object)("Online Doc Url for package '" + packageName + "' is: " + url));
            } else {
                logger.debug((Object)(prefix + " Url for package '" + packageName + "' is: " + url));
            }
        }
        return url;
    }

    private static String getUrl(String key, String packageName) {
        String url = null;
        if (!key.endsWith(".")) {
            key = key + ".";
        }
        while (packageName.length() > 0 && (url = errorDocs.getProperty(key + packageName, null)) == null) {
            int i = packageName.lastIndexOf(".");
            if (i == -1) {
                packageName = "";
                continue;
            }
            packageName = packageName.substring(0, i);
        }
        return url;
    }

    public static Throwable getRootException(Throwable t) {
        Throwable root = null;
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            root = cause;
        }
        return root;
    }

    public static Throwable getRootParentException(Throwable t) {
        Throwable parent = t;
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            if (cause.getCause() == null) {
                return parent;
            }
            parent = cause;
        }
        return t;
    }

    public static UMOException getRootMuleException(Throwable t) {
        UMOException umoException = null;
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof UMOException)) continue;
            umoException = (UMOException)cause;
        }
        return umoException;
    }

    public static String getExceptionStack(Throwable t) {
        StringBuffer buf = new StringBuffer();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            exceptions.add(0, cause);
        }
        int i = 1;
        Iterator iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            if (i > exceptionThreshold && exceptionThreshold > 0) {
                buf.append("(").append(exceptions.size() - i + 1).append(" more...)");
                break;
            }
            Throwable throwable = (Throwable)iterator.next();
            buf.append(i).append(". ").append(throwable.getMessage()).append(" (");
            buf.append(throwable.getClass().getName()).append(")\n");
            if (verbose) {
                StackTraceElement e = throwable.getStackTrace()[0];
                buf.append("  ").append(e.getClassName()).append(":").append(e.getLineNumber()).append(" (").append(ExceptionHelper.getJavaDocUrl(throwable.getClass())).append(")\n");
            }
            ++i;
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ExceptionHelper.initialise();
    }
}

