/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.NodeCreateRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleDtdResolver;
import org.mule.config.ReaderResource;
import org.mule.config.builders.MulePropertiesRuleSet;
import org.mule.config.builders.MuleSetPropertiesRule;
import org.mule.config.i18n.Message;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.util.ClassHelper;
import org.mule.util.Utility;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractDigesterConfiguration {
    public static final String DEFAULT_CONTAINER_CONTEXT = (class$org$mule$impl$container$MuleContainerContext == null ? (class$org$mule$impl$container$MuleContainerContext = AbstractDigesterConfiguration.class$("org.mule.impl.container.MuleContainerContext")) : class$org$mule$impl$container$MuleContainerContext).getName();
    public static final String FILTER_INTERFACE = (class$org$mule$umo$UMOFilter == null ? (class$org$mule$umo$UMOFilter = AbstractDigesterConfiguration.class$("org.mule.umo.UMOFilter")) : class$org$mule$umo$UMOFilter).getName();
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected Digester digester;
    protected List containerReferences = new ArrayList();
    static /* synthetic */ Class class$org$mule$impl$container$MuleContainerContext;
    static /* synthetic */ Class class$org$mule$umo$UMOFilter;

    protected AbstractDigesterConfiguration(boolean validate, String dtd) {
        this.digester = new Digester(){

            public void warning(SAXParseException e) throws SAXException {
                if (this.errorHandler != null) {
                    this.errorHandler.warning(e);
                }
            }
        };
        this.digester.setValidating(validate);
        this.digester.setEntityResolver((EntityResolver)new MuleDtdResolver(dtd));
        this.digester.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                AbstractDigesterConfiguration.this.logger.error((Object)exception.getMessage(), (Throwable)exception);
                throw new SAXException(exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                AbstractDigesterConfiguration.this.logger.fatal((Object)exception.getMessage(), (Throwable)exception);
                throw new SAXException(exception);
            }

            public void warning(SAXParseException exception) {
                AbstractDigesterConfiguration.this.logger.warn((Object)exception.getMessage());
            }
        });
    }

    protected ReaderResource[] parseResources(String configResources) throws ConfigurationException {
        String[] resources = Utility.split(configResources, ",");
        MuleManager.getConfiguration().setConfigResources(resources);
        ReaderResource[] readers = new ReaderResource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            try {
                readers[i] = new ReaderResource(resources[i].trim(), new InputStreamReader(this.loadConfig(resources[i].trim()), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException(e);
            }
        }
        return readers;
    }

    protected Object process(ReaderResource[] configResources) throws ConfigurationException {
        Object result = null;
        Reader configResource = null;
        for (int i = 0; i < configResources.length; ++i) {
            try {
                configResource = configResources[i].getReader();
                result = this.digester.parse(configResource);
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException(new Message(139, configResources[i].getDescription()), (Throwable)e);
            }
        }
        return result;
    }

    protected InputStream loadConfig(String configResource) throws ConfigurationException {
        InputStream is = ClassHelper.getResourceAsStream(configResource, this.getClass());
        if (is == null) {
            File file = new File(configResource);
            if (file.exists()) {
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new ConfigurationException(new Message(122, configResource), (Throwable)e);
                }
            }
            try {
                URL url = new URL(configResource);
                is = url.openStream();
            }
            catch (Exception e) {
                throw new ConfigurationException(new Message(122, configResource));
            }
        }
        return is;
    }

    public abstract String getRootName();

    protected void addContainerContextRules(String path, String setterMethod, int parentIndex) throws ConfigurationException {
        this.digester.addObjectCreate(path, DEFAULT_CONTAINER_CONTEXT, "className");
        this.addMulePropertiesRule(path, this.digester);
        NodeCreateRule nodeCreateRule = null;
        try {
            nodeCreateRule = new NodeCreateRule(11){
                private String encoding;
                private String doctype;

                public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                    this.encoding = attributes.getValue("encoding");
                    this.doctype = attributes.getValue("doctype");
                    super.begin(endpointName, endpointName1, attributes);
                }

                public void end(String endpointName, String endpointName1) throws Exception {
                    super.end(endpointName, endpointName1);
                    DocumentFragment config = (DocumentFragment)this.digester.pop();
                    StringWriter s = new StringWriter();
                    StreamResult streamResult = new StreamResult(s);
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    try {
                        Transformer transformer = tFactory.newTransformer();
                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                        transformer.transform(new DOMSource(config), streamResult);
                    }
                    catch (TransformerException e) {
                        throw new ContainerException(new Message(141), (Throwable)e);
                    }
                    StringReader reader = new StringReader(s.toString());
                    UMOContainerContext ctx = (UMOContainerContext)this.digester.peek();
                    ctx.configure(reader, this.doctype, this.encoding);
                }
            };
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(e);
        }
        this.digester.addRule(path + "/configuration", (Rule)nodeCreateRule);
        this.digester.addSetNext(path, setterMethod);
    }

    protected void addServerPropertiesRules(String path, String setterMethod, int parentIndex) {
        int i = path.lastIndexOf("/");
        this.addMulePropertiesRule(path.substring(0, i), this.digester, setterMethod, path.substring(i + 1));
    }

    protected void addSetPropertiesRule(String path, Digester digester) {
        digester.addRule(path, (Rule)new MuleSetPropertiesRule());
    }

    protected void addSetPropertiesRule(String path, Digester digester, String[] s1, String[] s2) {
        digester.addRule(path, (Rule)new MuleSetPropertiesRule(s1, s2));
    }

    protected void addMulePropertiesRule(String path, Digester digester) {
        digester.addRuleSet((RuleSet)new MulePropertiesRuleSet(path, this.containerReferences));
    }

    protected void addMulePropertiesRule(String path, Digester digester, String propertiesSetter) {
        digester.addRuleSet((RuleSet)new MulePropertiesRuleSet(path, propertiesSetter, this.containerReferences));
    }

    protected void addMulePropertiesRule(String path, Digester digester, String propertiesSetter, String parentElement) {
        digester.addRuleSet((RuleSet)new MulePropertiesRuleSet(path, propertiesSetter, this.containerReferences, parentElement));
    }

    protected void addFilterRules(Digester digester, String path) throws ConfigurationException {
        this.addSingleFilterRule(digester, path);
        path = path + "/filter";
        this.addFilterGroupRule(digester, path);
        this.addFilterGroupRule(digester, path + "/left-filter");
        this.addFilterGroupRule(digester, path + "/right-filter");
        this.addFilterGroupRule(digester, path + "/filter");
        this.addFilterGroupRule(digester, path + "/left-filter/left-filter");
        this.addFilterGroupRule(digester, path + "/left-filter/right-filter");
        this.addFilterGroupRule(digester, path + "/left-filter/filter");
        this.addFilterGroupRule(digester, path + "/right-filter/left-filter");
        this.addFilterGroupRule(digester, path + "/right-filter/right-filter");
        this.addFilterGroupRule(digester, path + "/right-filter/filter");
        this.addFilterGroupRule(digester, path + "/filter/left-filter");
        this.addFilterGroupRule(digester, path + "/filter/right-filter");
        this.addFilterGroupRule(digester, path + "/filter/filter");
    }

    protected void addFilterGroupRule(Digester digester, String path) throws ConfigurationException {
        this.addLeftFilterRule(digester, path);
        this.addRightFilterRule(digester, path);
        this.addSingleFilterRule(digester, path);
    }

    protected void addLeftFilterRule(Digester digester, String path) throws ConfigurationException {
        path = path + "/left-filter";
        digester.addObjectCreate(path, FILTER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetNext(path, "setLeftFilter");
    }

    protected void addRightFilterRule(Digester digester, String path) throws ConfigurationException {
        path = path + "/right-filter";
        digester.addObjectCreate(path, FILTER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetNext(path, "setRightFilter");
    }

    protected void addSingleFilterRule(Digester digester, String path) throws ConfigurationException {
        path = path + "/filter";
        digester.addObjectCreate(path, FILTER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetNext(path, "setFilter");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

