/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.MuleManager;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.WebappMuleXmlConfigurationBuilder;
import org.mule.umo.manager.UMOManager;

public class MuleXmlBuilderContextServlet
extends HttpServlet {
    public static final String CONFIG_INIT_PARAMETER = "org.mule.config";

    public void init() throws ServletException {
        try {
            String config = this.getServletContext().getInitParameter(CONFIG_INIT_PARAMETER);
            if (config == null) {
                config = this.getDefaultConfigResource();
            }
            this.createManager(config, this.getServletContext());
        }
        catch (ConfigurationException e) {
            this.getServletContext().log(e.getMessage(), (Throwable)e);
        }
    }

    protected UMOManager createManager(String configResource, ServletContext context) throws ConfigurationException {
        WebappMuleXmlConfigurationBuilder builder = new WebappMuleXmlConfigurationBuilder(context);
        return builder.configure(configResource);
    }

    protected String getDefaultConfigResource() {
        return "/WEB-INF/mule-config.xml";
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getServletContext().log("(" + request.getRequestURI() + ")" + "MuleXmlBuilderContextServlet.service(HttpServletRequest request, HttpServletResponse response) call ignored.");
        response.sendError(400);
    }

    public void destroy() {
        MuleManager.getInstance().dispose();
    }
}

