/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationException;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.manager.UMOManager;
import org.mule.util.BeanUtils;
import org.mule.util.ClassHelper;
import org.mule.util.PropertiesHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class PlaceholderProcessor {
    public static final String MULE_ENCRYPTION_PROPERTIES = "org.mule.config.encryption.properties";
    public static final String DEFAULT_ENCRYPTION_PROPERTIES_FILE = "mule-encryption.properties";
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$config$builders$PlaceholderProcessor == null ? (class$org$mule$config$builders$PlaceholderProcessor = PlaceholderProcessor.class$("org.mule.config.builders.PlaceholderProcessor")) : class$org$mule$config$builders$PlaceholderProcessor));
    private static boolean strategiesLoaded = false;
    private Map types = new HashMap();
    private Map schemes = new HashMap();
    static /* synthetic */ Class class$org$mule$config$builders$PlaceholderProcessor;
    static /* synthetic */ Class class$org$mule$impl$security$PasswordBasedEncryptionStrategy;

    public PlaceholderProcessor() {
        this.types.put("PBE", (class$org$mule$impl$security$PasswordBasedEncryptionStrategy == null ? (class$org$mule$impl$security$PasswordBasedEncryptionStrategy = PlaceholderProcessor.class$("org.mule.impl.security.PasswordBasedEncryptionStrategy")) : class$org$mule$impl$security$PasswordBasedEncryptionStrategy).getName());
    }

    public PlaceholderProcessor(Map types) {
        this.types = types;
    }

    public Attributes processAttributes(Attributes attributes, String elementName) throws ConfigurationException {
        AttributesImpl attribs = new AttributesImpl(attributes);
        String value = null;
        for (int i = 0; i < attribs.getLength(); ++i) {
            value = attribs.getValue(i);
            if ((value = this.processValue(value)) == null) {
                throw new ConfigurationException(new Message(158, "<" + elementName + attribs.getLocalName(i) + "='" + value + "' ...>"));
            }
            attribs.setValue(i, value);
        }
        return attribs;
    }

    public String processValue(String value) throws ConfigurationException {
        String realValue = null;
        String key = null;
        UMOManager manager = MuleManager.getInstance();
        int x = value.indexOf("${");
        while (x > -1) {
            int y = value.indexOf("}", x + 1);
            if (y == -1) {
                return null;
            }
            key = value.substring(x + 2, y);
            realValue = (String)manager.getProperty(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Param is '" + value + "', Property key is '" + key + "', Property value is '" + realValue + "'"));
            }
            if (realValue != null) {
                if ((realValue = this.processEncryptedValue(realValue)) == null) {
                    return null;
                }
                value = value.substring(0, x) + realValue + value.substring(y + 1);
            } else {
                logger.info((Object)("Property for placeholder: '" + key + "' was not found.  Leaving place holder as is. This is not necessarily a problem as the placeholder may not be a Mule placeholder."));
            }
            x = value.indexOf("${", y);
        }
        return value;
    }

    protected String processEncryptedValue(String value) throws ConfigurationException {
        int x = value.indexOf("{encrypt:");
        if (x > -1) {
            logger.debug((Object)"Value contains encrypted data.");
            int y = value.indexOf("}");
            if (y == -1) {
                logger.error((Object)("Encryption tag is malformed: " + value));
                return null;
            }
            String scheme = value.substring(x + 9, y);
            logger.debug((Object)("look up encryption scheme: " + scheme));
            try {
                UMOEncryptionStrategy strategy = this.getEncryptionStrategy(scheme);
                String data = value.substring(y + 1);
                byte[] decrypted = strategy.decrypt(data.getBytes(), null);
                return new String(decrypted);
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        return value;
    }

    public UMOEncryptionStrategy getEncryptionStrategy(String scheme) throws Exception {
        if (!strategiesLoaded) {
            this.loadStrategies();
        }
        return (UMOEncryptionStrategy)this.schemes.get(scheme);
    }

    private void loadStrategies() throws Exception {
        String path = System.getProperty(MULE_ENCRYPTION_PROPERTIES, MuleManager.getConfiguration().getWorkingDirectory() + File.separator + DEFAULT_ENCRYPTION_PROPERTIES_FILE);
        logger.info((Object)("Attempting to load encryption properties from: " + path));
        Properties props = PropertiesHelper.loadProperties(path);
        Map names = PropertiesHelper.getPropertiesWithPrefix(props, "name");
        Iterator iterator = names.values().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            Map schemeConfig = PropertiesHelper.getPropertiesWithPrefix(props, name + ".");
            String type = (String)(schemeConfig = PropertiesHelper.removeNamspaces(schemeConfig)).get("type");
            String clazz = (String)this.types.get(type);
            if (clazz == null) {
                throw new IllegalArgumentException("Unknown encryption type: " + type);
            }
            logger.debug((Object)("Found Class: " + clazz + " for type: " + type));
            UMOEncryptionStrategy strat = (UMOEncryptionStrategy)ClassHelper.instanciateClass(clazz, ClassHelper.NO_ARGS, class$org$mule$config$builders$PlaceholderProcessor == null ? PlaceholderProcessor.class$("org.mule.config.builders.PlaceholderProcessor") : class$org$mule$config$builders$PlaceholderProcessor);
            BeanUtils.populateWithoutFail(strat, schemeConfig, true);
            this.schemes.put(name, strat);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

